var BendyMenu = /** @class */ (function () {
    function BendyMenu() {
        var _this = this;
        this.select = function (s) { return document.querySelector(s); };
        this.selectAll = function (s) { return document.querySelectorAll(s); };
        this.mainTl = new TimelineMax();
        this.followerVY = 0;
        this.drinkFollowerVY = 0;
        this.uiSVG = this.select('#uiSVG');
        this.dragMinY = -300;
        this.pathDataStart = 'M.48,49s100.91,';
        this.bendyListItem = this.select('#bendyListItem');
        this.bendyUseItem = this.select('.bendyUseItem');
        this.dragContainer = this.select('#dragContainer');
        this.littleArrow = this.select('#littleArrow');
        this.xmlns = "http://www.w3.org/2000/svg";
        this.xlinkns = "http://www.w3.org/1999/xlink";
        this.container = this.select('#container');
        this.onRelease = function () {
        };
        this.onDrag = function () {
            var followerVY = dragContainer._gsTransform.y / 4;
            var halfVal = 180;
            var path = "" + _this.pathDataStart + followerVY + "," + halfVal + "," + followerVY + "," + halfVal + "," + -followerVY + "," + halfVal + "," + -followerVY;
            _this.bendyListItem.setAttribute('d', path);
        };
        this.onUpdate = function () {
            if (dragContainer._gsTransform.y > 0) {
                _this.onDrag();
                return;
            }
            var followerVY = -Math.round(_this.followerVY) * 0.993;
            var halfVal = 180;
            var path = "" + _this.pathDataStart + followerVY + "," + halfVal + "," + followerVY + "," + halfVal + "," + -followerVY + "," + halfVal + "," + -followerVY;
            _this.bendyListItem.setAttribute('d', path);
        };
        TweenMax.set('svg', {
            visibility: 'visible'
        });
        var follower = this.select('#follower');
        var drinkFollower = this.select('#drinkFollower');
        var viewingArea = this.select('#viewingArea');
        var viewingAreaHeight = Number(viewingArea.getAttribute('height'));
        var dragger = this.select('#dragger');
        var brandyLiquid = this.select('#brandyLiquid');
        var brandyCocktail = this.select('#brandyCocktail');
        var colorArr = ['#BA83D4', '#9FB6EE', '#EFB875', '#F97EA7', '#88EEED', '#B6DE7C'];
        var drinkUri = ['#brandyCocktail', '#screwdriverCocktail', '#cherryCocktail', '#champagne', '#punch', '#brandyCocktail', '#screwdriverCocktail', '#cherryCocktail', '#champagne', '#punch', '#brandyCocktail'];
        var labelArr = ['Piña Colada', 'Screwdriver', 'Marketing Champagne', 'Cherry Seinfeld', 'Fruit Punch', 'Tequila Sunset', 'Straight Whiskey', 'Martini Bopper', 'Harvey Wallbanger', 'Bloody Marvin', 'Woo Woo', ''];
        var i = drinkUri.length;
        var strokeWidth = Number(this.bendyListItem.getAttribute('stroke-width'));
        var numItems = drinkUri.length;
        while (--i > -1) {
            var clone = this.bendyUseItem.cloneNode(true);
            this.dragContainer.appendChild(clone);
            clone.querySelector('.drink').setAttributeNS(this.xlinkns, 'xlink:href', drinkUri[i % drinkUri.length]);
            TweenMax.set(clone, {
                x: 220,
                y: i * (strokeWidth) + (strokeWidth / 2) + 50
            });
            clone.querySelector('use').setAttribute('stroke', colorArr[i % colorArr.length]);
            clone.querySelector('text').textContent = labelArr[i % labelArr.length];
        }
        Draggable.create(this.dragContainer, {
            trigger: document.body,
            type: 'y',
            bounds: { minY: -((numItems - 1) * strokeWidth) + (viewingAreaHeight - strokeWidth), maxY: 0 },
            throwProps: true,
            onDrag: this.onDrag,
            throwResistance: 100,
            edgeResistance: 0.91,
            minDuration: 0.2,
            maxDuration: 0.85,
            ease: Expo.easeOut,
            onRelease: this.onRelease,
            overshootTolerance: 0.85,
            allowContextMenu: true
        });
        TweenMax.set('.drinkLiquid', {
            transformOrigin: '50% 50%'
        });
        TweenMax.set('#olive', {
            transformOrigin: '100% 100%'
        });
        TweenMax.to(follower, 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y, count) {
                    _this.followerVY += (_this.dragContainer._gsTransform.y - follower._gsTransform.y) * 0.8;
                    _this.followerVY *= 0.5;
                    return follower._gsTransform.y + _this.followerVY;
                }
            },
            onUpdate: this.onUpdate
        });
        TweenMax.to(drinkFollower, 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y, count) {
                    _this.drinkFollowerVY += (_this.dragContainer._gsTransform.y - drinkFollower._gsTransform.y) * 0.02;
                    _this.drinkFollowerVY *= 0.95;
                    return drinkFollower._gsTransform.y + _this.drinkFollowerVY;
                }
            }
        });
        TweenMax.to(this.littleArrow, 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y, count) {
                    return -_this.followerVY * 0.25;
                }
            }
        });
        TweenMax.to('text', 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y, count) {
                    return -_this.followerVY * 0.8;
                }
            }
        });
        TweenMax.staggerTo('.drinkItem', 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y, count) {
                    return -_this.drinkFollowerVY * 0.08;
                }
            }
        }, 0.1);
        TweenMax.to('.drinkLiquid', 1, {
            rotation: '+=0',
            repeat: -1,
            modifiers: {
                rotation: function (rotation) {
                    return _this.drinkFollowerVY * 0.58;
                }
            }
        });
        TweenMax.to('#olive', 1, {
            rotation: '+=0',
            repeat: -1,
            modifiers: {
                rotation: function (rotation) {
                    return Math.abs(_this.followerVY * 0.38);
                }
            },
            ease: Bounce.easeOut
        });
        TweenMax.to('.cocktail', 1, {
            y: '+=0',
            repeat: -1,
            modifiers: {
                y: function (y) {
                    return -_this.followerVY * 0.8;
                }
            }
        });
        document.addEventListener("touchmove", function (event) {
            event.preventDefault();
        });
        //ScrubGSAPTimeline(this.timeline);
        TweenMax.staggerFrom(this.nodeListToArray(this.selectAll('.bendyUseItem'), true), 1.3, {
            y: '+=500',
            ease: Elastic.easeOut.config(0.8, 0.8)
        }, 0.05);
        TweenMax.from(this.dragContainer, 1, {
            alpha: 0,
            ease: Sine.easeOut
        });
    }
    BendyMenu.prototype.nodeListToArray = function (list, rev) {
        var k = Array.prototype.slice.call(list);
        return (rev) ? k.reverse() : k;
    };
    return BendyMenu;
}());
var bendyMenu = new BendyMenu();