# [![Easy Toggle State](https://raw.githubusercontent.com/Twikito/easy-toggle-state/master/logo.png)](https://twikito.github.io/easy-toggle-state/)

__A tiny JavaScript library to easily toggle the state of any HTML element and its targets.__

Dropdown, navigation button, tooltip, collapsible panel, lightbox, tabs, switch like above…
UI components made in minutes without worried about JavaScript. Only set a few HTML attributes, and code the rest with your CSS skills.

[![npm version](https://badge.fury.io/js/easy-toggle-state.svg?style=flat-square)](https://badge.fury.io/js/easy-toggle-state)
[![dependencies Status](https://david-dm.org/Twikito/easy-toggle-state/status.svg?style=flat-square)](https://david-dm.org/Twikito/easy-toggle-state)
[![devDependencies Status](https://david-dm.org/Twikito/easy-toggle-state/dev-status.svg?style=flat-square)](https://david-dm.org/Twikito/easy-toggle-state?type=dev)
[![code style: prettier](https://img.shields.io/badge/code_style-prettier-ff69b4.svg?style=flat-square)](https://github.com/prettier/prettier)
[![contributions welcome](https://img.shields.io/badge/contributions-welcome-brightgreen.svg?style=flat-square)](https://github.com/Twikito/easy-toggle-state/issues)
[![GitHub license](https://img.shields.io/github/license/Twikito/easy-toggle-state.svg?style=flat-square)](https://github.com/Twikito/easy-toggle-state/blob/master/LICENSE)

## Why?

A front-end developer often has to __code scripts for interface components__. Components such as drop-downs, navigation buttons, tooltips, expandable panels, lightboxes, tabs, etc.

The thing is… Most of these components expose a __recurrent behavior__: a trigger element toggles the state of one or more target elements. So why not code this behavior once and for all?

So here is a solution: __a simple script to toggle the state of a trigger element__ with a CSS class. You can then __associate this element__ with one or more others: let's call them targets. By adding the right HTML attributes, it can __adapt to any contexts__ and behave like a chosen component.

__Only focus on adjusting the rest with your CSS creativity__.

## Quick start

Several quick start options are available:

- [Direct download](https://rawgit.com/Twikito/easy-toggle-state/master/dist/easy-toggle-state.es6.js)
- Choose another version: [ES5, ES6 or a build for IE11 with polyfills](https://github.com/Twikito/easy-toggle-state/tree/master/dist)
- Clone the repo: `git clone https://github.com/twikito/easy-toggle-state.git`
- Install with [npm](https://www.npmjs.com/package/easy-toggle-state): `npm install easy-toggle-state`

Then, __add the script into your page__, and it's done.

## Documentation

Easy Toggle State's documentation is hosted on GitHub Pages at [twikito.github.io/easy-toggle-state/](https://twikito.github.io/easy-toggle-state/).

## Contribution

- [Fork repository on GitHub](https://github.com/Twikito/easy-toggle-state/fork)
- [Report a bug](https://github.com/Twikito/easy-toggle-state/issues)
- [Suggest a feature](https://github.com/Twikito/easy-toggle-state/issues)
- Development: `npm run build`

## License

MIT. Copyright (c) [Matthieu Bué](https://twikito.com)
