﻿using Microsoft.AspNetCore.Authorization;
using Microsoft.AspNetCore.Mvc;
using Newtonsoft.Json;
using System.Linq;

// http://cryto.net/~joepie91/blog/2016/06/13/stop-using-jwt-for-sessions/

// https://goblincoding.com/2016/07/03/issuing-and-authenticating-jwt-tokens-in-asp-net-core-webapi-part-i/
// https://goblincoding.com/2016/07/07/issuing-and-authenticating-jwt-tokens-in-asp-net-core-webapi-part-ii/
// https://jwt.io/#debugger
// https://stackoverflow.com/questions/31109197/store-jwt-token-in-cookie
// https://andrewlock.net/a-look-behind-the-jwt-bearer-authentication-middleware-in-asp-net-core/
// https://jonhilton.net/2017/05/03/login-authentication-asp-net-core-web-api-big-picture/

//var url = "https://www.theidentityhub.com/{tenant}/api/identity/v1";
//client.DefaultRequestHeaders.Add("Authorization", "Bearer " + accessToken);
//    var response = await client.GetStringAsync(url);

// swager Bearer [token]
// Example :
// Bearer eyJhbGciOiJIUzI1NiIsInR5cCI6IkpXVCJ9.eyJzdWIiOiJhYSIsImp0aSI6ImVhZThmYTNjLTFhMTgtNDAzNi1iOTNiLTAwMTZjOGE5ODYyYiIsImlhdCI6MTQ5NjkzMjUzMywibmJmIjoxNDk2OTMyNTMyLCJleHAiOjE0OTczNjQ4MzIsImlzcyI6IlN1cGVyQXdlc29tZVRva2VuU2VydmVyIiwiYXVkIjoiaHR0cDovL2xvY2FsaG9zdDoxNzgzLyJ9.l-IYygKtuBap5RmEW_KJ4U156j65FQW_qk4-b3KHw6E

  // login security


namespace WebApiJwtAuthDemo.Controllers
{
  [Route("api/test")]
  [Authorize]
  public class JwtAuthTestController : Controller
  {
    private readonly JsonSerializerSettings _serializerSettings;

    public JwtAuthTestController()
    {
      _serializerSettings = new JsonSerializerSettings
      {
        Formatting = Formatting.Indented
      };
    }

    [HttpGet("ikke")]    
    public IActionResult Get2()
    {
      var response = new
      {
        made_it = "Welcome everyone!"
      };

      var json = JsonConvert.SerializeObject(response, _serializerSettings);
      return new OkObjectResult(json);
    }

    [HttpGet("disney")]
    [Authorize(Policy = "DisneyUser")]
    public IActionResult Get()
    {
      var userName = this.User.Claims.Where(e => e.Properties.Values.Contains("sub")).FirstOrDefault()?.Value;

      var response = new
      {
        made_it = "Welcome Mickey!"
      };

      var json = JsonConvert.SerializeObject(response, _serializerSettings);
      return new OkObjectResult(json);
    }

    [HttpGet("nodisney")]
    public IActionResult NoDisney()
    {
      var userName = this.User.Claims.Where(e => e.Properties.Values.Contains("sub")).FirstOrDefault()?.Value;

      var response = new
      {
        made_it = "Mickey is stupid!"
      };

      var json = JsonConvert.SerializeObject(response, _serializerSettings);
      return new OkObjectResult(json);
    }
  }
}