﻿using Resources.Shared;
using System;
using System.ComponentModel.DataAnnotations;

namespace Resources
{

  public class CountryResource : Resource<Int32>
  {    
    [Required]
    [Range(1, 999)]
    public override Int32 Id { get; set; }

    [Required]
    [StringLength(2, MinimumLength = 2, ErrorMessage = "Must be 2 chars long")]
    public String Code2 { get; set; }

    [Required]
    [StringLength(3, MinimumLength = 3, ErrorMessage = "Must be 3 chars long")]
    public String Code3 { get; set; }

    [Required]    
    [StringLength(50, MinimumLength = 2, ErrorMessage = "Name must be 2 to 50 chars long")]
    public String Name { get; set; }
  }
}
