window.addEventListener("resize", onWindowResize);

var frustumSize = 600;
var aspect = window.innerWidth / window.innerHeight;

var clock = new THREE.Clock(true);

var scene = new THREE.Scene();
// var camera = new THREE.OrthographicCamera( frustumSize * aspect / - 2, frustumSize * aspect / 2, frustumSize / 2, frustumSize / - 2, 1, 1000 );
var camera = new THREE.OrthographicCamera(
	window.innerWidth / -2,
	window.innerWidth / 2,
	window.innerHeight / 2,
	window.innerHeight / -2,
	1,
	1000
);

camera.lookAt(scene.position);
camera.position.z = 1;

var renderer = new THREE.WebGLRenderer({
	antialias: true,
	alpha: true
});

renderer.setPixelRatio = window.devicePixelRatio;
// renderer.setClearColor(0x3A405A, 1.0);
renderer.setClearColor(0xffffff, 1.0);
renderer.setSize(window.innerWidth, window.innerHeight);
document.body.appendChild(renderer.domElement);

function onWindowResize() {
	var _totalHeight = 600 * 0.132 * 4 / 2;

	camera.left = window.innerWidth / -2;
	camera.right = window.innerWidth / 2;
	camera.top = window.innerHeight / 2;
	camera.bottom = window.innerHeight / -2;

	camera.updateProjectionMatrix();

	renderer.setSize(window.innerWidth, window.innerHeight);

	for (var p = 0; p < document.querySelectorAll(".hit-area").length; p++) {
		var _hit = document.querySelectorAll(".hit-area")[p];
		_hit.style.top = window.innerHeight * 0.5 - _totalHeight + 200 * 0.132 + "px";
		_totalHeight -= 600 * 0.132;
	}
}

var addToGPU = function(t) {
	renderer.setTexture2D(t, 0);
};

var loader = new THREE.TextureLoader();
loader.crossOrigin = "";

var textures1 = [
	loader.load("https://robindelaporte.fr/codepen/menu/agency.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/discover.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/team.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/contact.png", function(
		texture
	) {
		addToGPU(texture);
	})
];

var textures2 = [
	loader.load("https://robindelaporte.fr/codepen/menu/home.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/work.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/meetus.png", function(
		texture
	) {
		addToGPU(texture);
	}),
	loader.load("https://robindelaporte.fr/codepen/menu/connect.png", function(
		texture
	) {
		addToGPU(texture);
	})
];

var angles = [Math.PI / 180 * 90, Math.PI / 180 * 270, 0, Math.PI / 180 * 180];
var directions = [-1, 1, -1, 1];

var disp = loader.load("https://robindelaporte.fr/codepen/menu/stripe1.png");
disp.wrapS = disp.wrapT = THREE.RepeatWrapping;

var gui = new dat.GUI();
var textures = {
	stripes: loader.load("https://robindelaporte.fr/codepen/menu/strip.png"),
	fluid: loader.load("https://robindelaporte.fr/codepen/menu/fluid.png"),
	dot: loader.load("https://robindelaporte.fr/codepen/menu/dot.jpg"),
	deformation: loader.load(
		"https://robindelaporte.fr/codepen/menu/deformation.png"
	),
	noise: loader.load("https://robindelaporte.fr/codepen/menu/noise.gif"),
	noise1: loader.load("https://robindelaporte.fr/codepen/menu/noise1.jpg"),
	noise2: loader.load("https://robindelaporte.fr/codepen/menu/noise2.jpg"),
	stripe1: loader.load("https://robindelaporte.fr/codepen/menu/stripe1.png")
};

var self = this;
var texture = new function() {
	this.changeMask = function(e) {
		switch (e) {
			case "dot":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.dot;
				}
				break;
			case "deformation":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.deformation;
				}
				break;
			case "noise":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.noise;
				}
				break;
			case "noise1":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.noise1;
				}
				break;
			case "noise2":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.noise2;
				}
				break;
			case "stripes":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.stripes;
				}
				break;
			case "stripe1":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.stripe1;
				}
				break;
			case "fluid":
				for (var i = 0; i < 4; i++) {
					btns[i].material.uniforms.disp.value = self.textures.fluid;
				}
				break;
		}
	};
}();

gui
	.add(texture, "changeMask", [
		"stripe1",
		"fluid",
		"dot",
		"stripes",
		"deformation",
		"noise",
		"noise1",
		"noise2"
	])
	.onChange(texture.changeMask)
	.name("change transition");

var newMat = function(texture1, texture2, angle, dir) {
	texture1.magFilter = THREE.LinearFilter;
	texture1.minFilter = THREE.LinearMipMapLinearFilter;

	texture2.magFilter = THREE.LinearFilter;
	texture2.minFilter = THREE.LinearMipMapLinearFilter;

	var mat = new THREE.ShaderMaterial({
		uniforms: {
			dispFactor: { type: "f", value: 0.0 },
			rot: { type: "f", value: angle },
			direction: { type: "f", value: dir },
			texture: { type: "t", value: texture1 },
			texture2: { type: "t", value: texture2 },
			disp: { type: "t", value: disp }
		},

		vertexShader: document.getElementById("vertexShader").textContent,
		fragmentShader: document.getElementById("fragmentShader").textContent,
		transparent: true,
		opacity: 1.0
	});
	return mat;
};

var geometry = new THREE.PlaneBufferGeometry(400, 400, 1);

var btns = [];

var totalHeight = 600 * 0.132 * 4 / 2;

for (var i = 0; i < 4; i++) {
	var hit = document.createElement("div");
	hit.className = "hit-area";
	document.querySelector(".hits").appendChild(hit);

	hit.style.width = 400 * 0.92 + "px";
	hit.style.height = 400 * 0.132 + "px";

	hit.style.top = window.innerHeight * 0.5 - totalHeight + 200 * 0.132 + "px";

	var item = new THREE.Mesh(
		geometry,
		newMat(textures1[i], textures2[i], angles[i], directions[i])
	);
	// item.position.y += i * 100;
	item.position.y += totalHeight - 200 * 0.132;
	scene.add(item);

	btns.push(item);

	totalHeight -= 600 * 0.132;
}

for (var b = 0; b < document.querySelectorAll(".hit-area").length; b++) {
	var item = document.querySelectorAll(".hit-area")[b];

	item.addEventListener("mouseenter", function(e) {
		var index = Array.prototype.indexOf.call(
			this.parentElement.children,
			e.target
		);
		TweenMax.to(btns[index].material.uniforms.dispFactor, 1.5, {
			value: 1,
			ease: Expo.easeOut
		});
	});

	item.addEventListener("mouseleave", function(e) {
		var index = Array.prototype.indexOf.call(
			this.parentElement.children,
			e.target
		);
		TweenMax.to(btns[index].material.uniforms.dispFactor, 1.5, {
			value: 0,
			ease: Expo.easeOut
		});
	});
}

var animate = function() {
	requestAnimationFrame(animate);

	renderer.render(scene, camera);
};
animate();