﻿using Excel.Models;
using FnS.Excel.Models;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using System.Xml.Linq;

namespace Excel.Controllers
{
    public class HomeController : Controller
    {
        public ActionResult Index()
        {
            return View();
        }

        public ActionResult About()
        {
            ViewBag.Message = "Your application description page.";

            return View();
        }

        public ActionResult Contact()
        {
            ViewBag.Message = "Your contact page.";

            return View();
        }

        public ActionResult ExportExcel(ExcelModel excelModel)
        {
            ExcelHelper excelHelper= new ExcelHelper();
            ExcelMeta meta = excelHelper.GetExcelMeta(excelModel.Data);


            byte[] content = excelHelper.GetExcelDocument(meta);
            FileContentResult result = new FileContentResult(content, "application/vnd.openxmlformats-officedocument.spreadsheetml.sheet")
            {
                FileDownloadName = "CARS.xlsx"
            };

            return result;
        }
    }
}