﻿$(document).ready(function () {

    $('.js-page-link').click(function () {
        var $this = $(this);
        var $form = $('.js-form-pagination');
        var pageIndex = $this.data('index');
        var $pageIndex = $form.find('input[name="PageIndex"]');
        if ($this.parent().hasClass('disabled')) {
            return;
        }
        $pageIndex.val(pageIndex);
        $form.submit();
    });

    $('.js-page-orderby').click(function () {
        var $this = $(this);
        var orderByPath = $this.data('orderby');
        var thenByPath = $this.data('thenby');
        var descending = false;
        var $form = $('.js-form-pagination');
        var $pageIndex = $form.find('input[name="PageIndex"]');
        var $filters = $form.find('div.js-page-filter');
        var $filter = $('<div class="js-page-filter">');
        var $input = null;
        var $existingFilter = $('div.js-page-filter input[name$="Discriminator"][value="OrderByFilter"]').closest('.js-page-filter');
        var existingPath, existingDescending = null;
        //Check if an orderByFilter exists
        if ($existingFilter.length > 0) {
            existingPath = $existingFilter.find('input[name$="PropertyPath"]').val();
            existingDescending = $existingFilter.find('input[name$="Descending"]').val();
            descending = !existingDescending;
        }
        //Reset the page index
        $pageIndex.val(0);
        //Clear query filters
        $filters.remove();
        //Create new OrderByFilter
        $input = $('<input type="hidden" name="Filters[0].Discriminator" value="OrderByFilter">');
        $filter.append($input);
        $input = $('<input type="hidden" name="Filters[0].Descending" value="' + descending + '">');
        $filter.append($input);
        $input = $('<input type="hidden" name="Filters[0].PropertyPath" value="' + orderByPath + '">');
        $filter.append($input);
        $form.append($filter);
        //Create new ThenByFilter if required
        if (thenByPath !== undefined) {
            $filter = $('<div class="js-page-filter">');
            $input = $('<input type="hidden" name="Filters[1].Discriminator" value="ThenByFilter">');
            $filter.append($input);
            $input = $('<input type="hidden" name="Filters[1].Descending" value="' + descending + '">');
            $filter.append($input);
            $input = $('<input type="hidden" name="Filters[1].PropertyPath" value="' + orderByPath + '">');
            $filter.append($input);
            $form.append($filter);
        }
        //Submit the form
        $form.submit();
    });

    $('.js-page-items').on('change', function (e) {
        var $this = $(this);
        var $form = $('.js-form-pagination');
        var $pageIndex = $form.find('input[name="PageIndex"]');
        $pageIndex.val(0);
        $form.submit();
    });

    $('.js-search-do').click(function () {
        var $form = $('.js-form-pagination');
        var searchBy = $('.js-search-by').val();
        var searchValue = $('.js-search-value').val();
        var comparisonMode = $('.js-search-mode').val();
        //var caseSentitive = $('.js-search-caseSensitive').is(':checked');
        var $filters = $form.find('div.js-page-filter');
        var $filter = $('<div class="js-page-filter">');
        var $pageIndex = $form.find('input[name="PageIndex"]');
        //Reset the page index
        $pageIndex.val(0);
        //Clear query filters
        $filters.remove();
        //Create new WhereFilter
        $input = $('<input type="hidden" name="Filters[0].Discriminator" value="WhereFilter">');
        $filter.append($input);
        $input = $('<input type="hidden" name="Filters[0].PropertyPath" value="' + searchBy + '">');
        $filter.append($input);
        $input = $('<input type="hidden" name="Filters[0].ValueComparison" value="' + comparisonMode + '">');
        $filter.append($input);
        //$input = $('<input type="hidden" name="Filters[0].CaseSensitive" value="' + caseSentitive + '">');
        //$filter.append($input);
        $input = $('<input type="hidden" name="Filters[0].Value" value="' + searchValue + '">');
        $filter.append($input);
        $form.append($filter);
        //Submit the form
        $form.submit();
    });

    $('.js-search-clear').click(function () {
        var $form = $('.js-form-pagination');
        var $filters = $form.find('div.js-page-filter');
        //Clear query filters
        $filters.remove();
        //Submit the form
        $form.submit();
    });

});