﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DynamicSearchesExample.Models
{

    /// <summary>
    /// Defines the basic interaction logic of all <see cref="QueryFilter"/> implementations
    /// </summary>
    [ModelBinder(typeof(ModelAbstractionBinder<QueryFilter>))]
    public abstract class QueryFilter
    {

        /// <summary>
        /// Gets/sets a string that represents the <see cref="QueryFilter"/>'s discriminator, which is the type name of the <see cref="QueryFilter"/> implementation
        /// </summary>
        public string Discriminator { get; set; }

        /// <summary>
        /// Filters the specified query
        /// </summary>
        /// <param name="entityType">The type of the query</param>
        /// <param name="query">The query to filter</param>
        /// <returns>The filtered query</returns>
        public abstract IQueryable Filter(Type entityType, IQueryable query);

        /// <summary>
        /// Filters the specified query
        /// </summary>
        /// <typeparam name="TEntity">The type of the query to filter</typeparam>
        /// <param name="query">The query to filter</param>
        /// <returns>The filtered query</returns>
        public IQueryable<T> Filter<T>(IQueryable<T> query)
        {
            object result;
            result = this.Filter(typeof(T), query);
            return result as IQueryable<T>;
        }

    }

}