﻿using System;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Data.Entity;
using System.Linq;
using System.Web;

namespace DynamicSearchesExample.Models
{

    public class DbContextMockup
        : DbContext
    {

        public DbContextMockup()
            : base("DefaultConnection")
        {
            Database.SetInitializer(new DbContextInitializer());
        }

        public DbSet<UserMockup> Users { get; set; }

    }

    public class DbContextInitializer
        : CreateDatabaseIfNotExists<DbContextMockup>
    {

        protected override void Seed(DbContextMockup context)
        {
            context.Users.Add(new UserMockup()
            {
                FirstName = "Shenikwa",
                LastName = "De'Andre",
                DateOfBirth = new DateTime(1958, 10, 2),
                Address = "Somewhere Fancy 69, 65455 CityName, USA",
                Email = "shenikwa@mailinator.com"
            });
            context.Users.Add(new UserMockup()
            {
                FirstName = "Silversting",
                LastName = "Stallion",
                DateOfBirth = new DateTime(1958, 10, 2),
                Address = "Animal Lovers Street 3987, 65455 CityName, Germany",
                Email = "raginghorse@mailinator.com"
            });
            context.Users.Add(new UserMockup()
            {
                FirstName = "Al",
                LastName = "Padchénou",
                DateOfBirth = new DateTime(1987, 4, 8),
                Address = "Dump Avenue 1789, 65455 CityName, Nowhere",
                Email = "Padchénou.édchéluinonplus@mailinator.com"
            });
        }

    }

}