﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;

namespace DynamicSearchesExample
{

    /// <summary>
    /// Defines extension methods for the <see cref="Type"/> class
    /// </summary>
    public static class TypeExtensions
    {

        /// <summary>
        /// Gets a boolean indicating whether or not the type is a system value type
        /// </summary>
        /// <param name="extended">The extended type</param>
        /// <returns>A boolean indicating whether or not the type is a system value type</returns>
        public static bool IsSystemValueType(this Type extended)
        {
            if (extended.IsValueType)
            {
                return true;
            }
            if (extended == typeof(string))
            {
                return true;
            }
            if (extended == typeof(Guid))
            {
                return true;
            }
            if (extended == typeof(DateTime))
            {
                return true;
            }
            if (extended == typeof(Version))
            {
                return true;
            }
            if (extended.IsEnum)
            {
                return true;
            }
            return false;
        }

        /// <summary>
        /// Gets a boolean indicating whether or not the type is nullable
        /// </summary>
        /// <param name="extended">The extended type</param>
        /// <returns>A boolean indicating whether or not the type is nullable</returns>
        public static bool IsNullable(this Type extended)
        {
            if (extended.IsGenericType)
            {
                if (extended.GetGenericTypeDefinition() == typeof(Nullable<>))
                {
                    return true;
                }
            }
            if (extended.IsSubclassOf(typeof(Nullable<>)))
            {
                return true;
            }
            if (extended == typeof(String))
            {
                return true;
            }
            return false;
        }

    }

}