﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Runtime.Caching;
using System.Web;

namespace DynamicSearchesExample
{

    /// <summary>
    /// Defines and exposes static members to search types and cache the search's results
    /// </summary>
    public static class TypeCacheUtil
    {

        private static MemoryCache Cache = new MemoryCache("neuro-typecache");

        /// <summary>
        /// Find all types that matches the specified predicate
        /// </summary>
        /// <param name="cacheName">The name of the cache entry to store the filtered types to</param>
        /// <param name="predicate">The predicate used to filter types</param>
        /// <returns>An <see cref="IEnumerable{T}"/> of all the types matching the specified predicate</returns>
        public static IEnumerable<Type> FindFilteredTypes(string cacheName, Func<Type, bool> predicate)
        {
            IEnumerable<Type> types;
            List<Type> result;
            if (TypeCacheUtil.Cache.Contains(cacheName))
            {
                return (IEnumerable<Type>)TypeCacheUtil.Cache[cacheName];
            }
            types = AssemblyLocator.GetAssemblies().ToList().SelectMany(a => a.DefinedTypes);
            result = new List<Type>(types.Count());
            foreach (Type type in types)
            {
                if (predicate(type))
                {
                    result.Add(type);
                }
            }
            return result;
        }

    }

}