﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.Collections.ObjectModel;
using System.Linq;
using System.Web;

namespace DynamicSearchesExample
{

    /// <summary>
    /// A thread-safe implementation of the <see cref="ICollection"/> interface
    /// </summary>
    /// <typeparam name="T">The type of the elements contained by the collection</typeparam>
    public class SynchronizedCollection<T>
        : ICollection<T>
    {

        public SynchronizedCollection()
        {
            this.SyncRoot = new object();
            this.UnderlyingCollection = new Collection<T>();
        }

        protected object SyncRoot { get; private set; }

        protected Collection<T> UnderlyingCollection { get; private set; }

        public int Count
        {
            get
            {
                lock (this.SyncRoot)
                {
                    return this.UnderlyingCollection.Count;
                }
            }
        }

        public bool IsReadOnly
        {
            get
            {
                return false;
            }
        }

        public void Add(T item)
        {
            lock (this.SyncRoot)
            {
                this.UnderlyingCollection.Add(item);
            }
        }

        public void Clear()
        {
            lock (this.SyncRoot)
            {
                this.UnderlyingCollection.Clear();
            }
        }

        public bool Contains(T item)
        {
            lock (this.SyncRoot)
            {
                return this.UnderlyingCollection.Contains(item);
            }
        }

        public void CopyTo(T[] array, int arrayIndex)
        {
            this.UnderlyingCollection.CopyTo(array, arrayIndex);
        }

        public IEnumerator<T> GetEnumerator()
        {
            lock (this.SyncRoot)
            {
                return this.UnderlyingCollection.GetEnumerator();
            }
        }

        public bool Remove(T item)
        {
            lock (this.SyncRoot)
            {
                return this.UnderlyingCollection.Remove(item);
            }
        }

        IEnumerator IEnumerable.GetEnumerator()
        {
            return this.GetEnumerator();
        }

    }

}