﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DynamicSearchesExample
{

    /// <summary>
    /// The <see cref="IModelBinder"/> implementation used to bind abstract classes
    /// </summary>
    /// <typeparam name="T">The type of the model to bind</typeparam>
    public class ModelAbstractionBinder<T>
        : DefaultModelBinder
    {

        public override object BindModel(ControllerContext controllerContext, ModelBindingContext bindingContext)
        {
            string key, discriminator;
            IEnumerable<Type> searchFilterTypes;
            Type searchFilterType;
            //Find the Discriminator value in the current request's form data
            key = controllerContext.HttpContext.Request.Form.Keys.OfType<string>().FirstOrDefault(k => k.Contains("Discriminator"));
            discriminator = controllerContext.HttpContext.Request.Form[key];
            if (string.IsNullOrWhiteSpace(discriminator))
            {
                //The Discriminator value is null, we therefore cannot do anything
                return base.BindModel(controllerContext, bindingContext);
            }
            //Find the loaded type that matches the Discriminator's value
            searchFilterTypes = TypeCacheUtil.FindFilteredTypes(typeof(T).Name, (type) => typeof(T).IsAssignableFrom(type));
            searchFilterType = searchFilterTypes.FirstOrDefault(sft => sft.Name == discriminator);
            if (searchFilterType == null)
            {
                throw new NullReferenceException("Failed to find a " + typeof(T).Name + " with the specified discriminator '" + discriminator + "'");
            }
            //Set the ModelMetadata, used by the DefaultModelBinder to do all the binding work
            bindingContext.ModelMetadata = ModelMetadataProviders.Current.GetMetadataForType(null, searchFilterType);
            //Let the DefaultModelBinding do the work for us
            return base.BindModel(controllerContext, bindingContext);
        }

    }

}