﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Reflection;
using System.Web;

namespace DynamicSearchesExample
{

    /// <summary>
    /// Defines and exposes static members to help handling <see cref="Assembly"/>
    /// </summary>
    public static class AssemblyLocator
    {

        /// <summary>
        /// The <see cref="SynchronizedCollection{T}"/> that references all loaded assemblies
        /// </summary>
        private static SynchronizedCollection<Assembly> LoadedAssemblies = new SynchronizedCollection<Assembly>();

        /// <summary>
        /// The static constructor of the <see cref="AssemblyLocator"/> class
        /// </summary>
        static AssemblyLocator()
        {
            foreach (Assembly assembly in AppDomain.CurrentDomain.GetAssemblies())
            {
                AssemblyLocator.LoadedAssemblies.Add(assembly);
            }
            AppDomain.CurrentDomain.AssemblyLoad += AssemblyLocator.OnAssemblyLoad;
        }

        /// <summary>
        /// Gets all the <see cref="Assembly"/> instances
        /// </summary>
        /// <returns>All the <see cref="Assembly"/> instances</returns>
        public static IEnumerable<Assembly> GetAssemblies()
        {
            return AssemblyLocator.LoadedAssemblies.AsEnumerable();
        }

        /// <summary>
        /// Handles the <see cref="AppDomain.AssemblyLoad"/> event
        /// </summary>
        /// <param name="sender">The sender of the event</param>
        /// <param name="e">The <see cref="AssemblyLoadEventArgs"/> associated with the event</param>
        private static void OnAssemblyLoad(object sender, AssemblyLoadEventArgs e)
        {
            AssemblyLocator.LoadedAssemblies.Add(e.LoadedAssembly);
        }

    }

}