﻿using DynamicSearchesExample.Models;
using Microsoft.AspNet.Identity.Owin;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace DynamicSearchesExample.Controllers
{

    public class HomeController 
        : Controller
    {

        public DbContextMockup DbContext
        {
            get
            {
                return this.HttpContext.GetOwinContext().Get<DbContextMockup>();
            }
        }

        [HttpGet]
        public ActionResult Index()
        {
            QueryViewModel<UserMockup> model;
            model = new QueryViewModel<UserMockup>()
            {
                ResultsPerPage = 50
            };
            model.ExecuteQuery(this.DbContext);
            return this.View(model);
        }

        [HttpPost]
        public ActionResult Index(QueryViewModel<UserMockup> model)
        {
            if (!this.ModelState.IsValid)
            {
                return this.View(model);
            }
            model.ExecuteQuery(this.DbContext);
            return this.View(model);
        }

    }

}