# Summary
 The chart has been updated to version v3.0.0.

The purpose of this major update is to redesign the chart.

We improved the basic style to be more polished so that users don’t have to customize it.

The biggest change is a visual design change, two options that are no longer needed are removed, and two options are added.

When upgrading to v3.0.0, there is no big change in function but there are many design changes such as basic line thickness of chart, title position, dot size and so on. 
Because of so there are some areas to carefully check when applying.

This document will walk you through the [Design Changes](#change-design) and [What to Watch Out for When Upgrading to a New Version](#be-careful-when-updating-versions).

# Be careful when updating versions
#### The following is a very noticeable part of many changes, Detailed changes are described in detail in the [Design Changes](#change-design)

1. The alignment of the chart titles changed from left-aligned to centered, which may be very different from what you original version intended
    - Instead, the (chart.title.offsetX) option can adjust the position of the title
2. y-axis title option The `yAxis.rotateTitle` option is removed and the default position changes to the top of the y-axis, which may not be what the old version intended
3. Pie chart [(show more)](#8-pie-chart)
    - When series.showLabel is set to true, the sereis value label is always centered, regardless of the series.labelAlign option, and may not look like the intent of the old version
    - The font size of valueLabel may be fixed at 16px and may not look as intended in the original version
4. Line chart [(show more)](#4-line-chart)
    - The line thickness of the line chart has been changed from 2px to 6px, and the size of the dot is also changed to 5px, which may not look like the intent shown in previous versions
    - Likewise, combo charts with line charts may look different from previous versions
5. Area chart [(show more)](#5-area-chart)
    - The default thickness of the line representation has been changed from 2px to 6px, and the dot size changed, which may look different from previous versions
    - The opacity of the area and its default state representation have changed, which may look defferent from previous versions


# Change design
### 1. Chart common part
- change chart default color specified in defaultTheme
- chart title sort has been changed from center sort to left sort
- y axis title position has been changed to top
- change to x-axis title position left alignment
- changed x, y axis line thickness to look thinner
- change legend area checkbox appearance and icon appearance
- change the default appearance of tooltip
- exportMenu Change appearance

### 2. Bar chart
- removed the gap between the bars
- change the mouseover effect

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 15 19](https://user-images.githubusercontent.com/35218826/36961894-9bf5a18c-2090-11e8-8281-489824fe1aa2.png)|![2018-03-05 4 15 52](https://user-images.githubusercontent.com/35218826/36961899-a2a99470-2090-11e8-9663-7d4014435656.png)|


### 3. Column chart
- removed the gap between the bars.
- change the mouseover effect.

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 25 55](https://user-images.githubusercontent.com/35218826/36962203-ef9d75fc-2091-11e8-9e2d-866ac2e6a9b8.png)|![2018-03-05 4 25 28](https://user-images.githubusercontent.com/35218826/36962206-f201ecb0-2091-11e8-87af-5f95e22efbc1.png)|


### 4. Line chart
- the default line thickness has increased (2px => 6px)
- change the size and shape of the default dot

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 30 38](https://user-images.githubusercontent.com/35218826/36962387-b77d8c10-2092-11e8-86c0-fc3b637ce869.png)|![2018-03-05 4 31 00](https://user-images.githubusercontent.com/35218826/36962392-bae57408-2092-11e8-8ea9-473100d55f90.png)|



### 5. Area chart
- change the default appearance of area
  - Default areaOpacity changed from 0.5 to 1
- change the shape and animation effect when mouseover
  - the default line thickness has increased (2px => 6px)
  - The mouseover area area changed to transparent
  
| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 37 05](https://user-images.githubusercontent.com/35218826/36962641-b7aefe20-2093-11e8-9a13-88e7e77f9ad0.png)|![2018-03-05 5 30 27](https://user-images.githubusercontent.com/35218826/36964733-edee994e-209a-11e8-90c8-4d43656bb45a.png)|

### 6. Bubble chart
- the opacity of the basic bubble has been changed from 0.5 to 0.8
- change the shape and animation effect when mouseover

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 42 07](https://user-images.githubusercontent.com/35218826/36962792-50b48ed2-2094-11e8-9f77-dd9db1401ac1.png)|![2018-03-05 4 42 48](https://user-images.githubusercontent.com/35218826/36962793-50e40b58-2094-11e8-9a73-c1ebf1d6d7e1.png)|


### 7. Scatter chart
- default scatter opacity has been changed from 0.5 to 0.8

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 46 23](https://user-images.githubusercontent.com/35218826/36962935-c969acea-2094-11e8-9f15-e6bfbb1804c8.png)|![2018-03-05 4 46 15](https://user-images.githubusercontent.com/35218826/36962934-c92bde4c-2094-11e8-817d-8bcc1c4b806a.png)|


### 8. Pie chart
- The series label status of the pie chart has been changed
  - regardless of the labelAlign option, the sereis value label is always centered (applies only to legend labels)
  - when the labelAlign option is outer, the color of the legend label of the series is changed to be applied
- change the mouseover effect

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 51 51](https://user-images.githubusercontent.com/35218826/36963176-89fb9414-2095-11e8-85ef-b16e2e7262ea.png)|![2018-03-05 4 49 30](https://user-images.githubusercontent.com/35218826/36963091-474d9da6-2095-11e8-814d-26f6a387336b.png)|



### 9. Map chart
- zoom button position change
- change default spectrum color
- change spectrum legend shape
- change the shape and animation effect when mouseover

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 56 14](https://user-images.githubusercontent.com/35218826/36963345-29aba7ba-2096-11e8-8566-6251d77f9dda.png)|![2018-03-05 4 55 49](https://user-images.githubusercontent.com/35218826/36963344-295d8972-2096-11e8-886f-c77d71b20407.png)|


### 10. Heatmap chart
- change default spectrum color
- change spectrum legend shape
- change the shape and animation effect when mouseover

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 4 59 26](https://user-images.githubusercontent.com/35218826/36963476-b0b7cbc6-2096-11e8-9df7-4a3e98691e48.png)|![2018-03-05 4 58 46](https://user-images.githubusercontent.com/35218826/36963475-b076c45a-2096-11e8-9ee8-19b397a67f77.png)|


### 11. Treemap chart
- The color representation of the series has been changed

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 5 04 08](https://user-images.githubusercontent.com/35218826/36963617-52fcc4ae-2097-11e8-8056-201fca1082a8.png)|![2018-03-05 5 04 34](https://user-images.githubusercontent.com/35218826/36963618-532d7522-2097-11e8-9139-390c49dc5a31.png)|


### 12. Radial chart
- the default line thickness has increased (2px => 6px)
- change the mouseover effect

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 5 08 07](https://user-images.githubusercontent.com/35218826/36963764-e04ce546-2097-11e8-9289-3fb0e6f21ed0.png)|![2018-03-05 5 07 24](https://user-images.githubusercontent.com/35218826/36963763-e01eb572-2097-11e8-8b15-b95ca56d66f9.png)|


### 13. Boxplot chart
- series area color representation changed
- change the mouseover effect

| 2.16.x | 3.0.0 |
| --- | --- |
|![2018-03-05 5 13 19](https://user-images.githubusercontent.com/35218826/36963975-93d36fea-2098-11e8-8ad7-23fe4085f74b.png)|![2018-03-05 5 12 37](https://user-images.githubusercontent.com/35218826/36963974-93a45750-2098-11e8-859f-d13b84db798c.png)|

# Option changes
### Options added
| name | Explanation |
| --- | --- |
| legend.reversed | In Spectrum Legend, change the output order in reverse order. |
| xAxis.showLabel<br>yAxis.showLabel | Hide or show labels on the x or y axis |

### Options removed
| name | Explanation |
| --- | --- |
| yAxis.rotateTitle | The option to rotate the y-axis title has been removed (removed as an option that is not appropriate for the changed design) |
| tooltip.position | Removed the `tooltip.position` option that was deprecated (can be replaced with `tooltip.offsetX` or `tooltip.offsetY`)|
