<?php
/** 
 * Default file extensions and its mime types.
 * 
 * To create your own extension => mime types, please write all keys and values in lower case only.
 * 
 * @author Vee W.
 * @license http://opensource.org/licenses/MIT MIT
 */


return array(
    '7z' => array('application/x-7z-compressed'),
    'aac' => array('audio/aac', 'audio/aacp', 'audio/x-aac'),
    'avi' => array('video/x-msvideo'),
    'bmp' => array('image/bmp'),
    'css' => array('text/css'),
    'csv' => array('application/csv', 'application/excel', 'application/vnd.ms-excel', 'application/vnd.msexcel', 'application/x-csv', 'text/comma-separated-values', 'text/csv', 'text/x-comma-separated-values', 'text/x-csv'),
    'doc' => array('application/msword'),
    'docx' => array('application/vnd.openxmlformats-officedocument.wordprocessingml.document'),
    'dvi' => array('application/x-dvi'),
    'flv' => array('video/x-flv'),
    'gif' => array('image/gif'),
    'gz' => array('application/x-gzip'),
    'h264' => array('video/h264'),
    'h.264' => array('video/h264'),
    'htm' => array('text/html'),
    'html' => array('text/html'),
    'jpg' => array('image/jpeg', 'image/pjpeg'),
    'jpe' => array('image/jpeg', 'image/pjpeg'),
    'jpeg' => array('image/jpeg', 'image/pjpeg'),
    'js' => array('application/x-javascript', 'text/javascript'),
    'json' => array('application/json', 'text/json'),
    'log' =>	array('text/plain', 'text/x-log'),
    'mid' => array('application/midi'),
    'midi' => array('application/midi'),
    'mov' => array('video/quicktime'),
    'mp3' => array('audio/mp3', 'audio/mpeg', 'audio/mpeg3', 'audio/mpg'),
    'mp4' => array('application/mp4', 'video/mp4'),
    'mpe' => array('video/mpeg'),
    'mpeg' => array('video/mpeg'),
    'mpg' => array('video/mpeg'),
    'pdf' => array('application/pdf', 'application/x-download'),
    'png' => array('image/png', 'image/x-png'),
    'ppt' => array('application/powerpoint', 'application/vnd.ms-powerpoint'),
    'tar' => array('application/x-tar'),
    'tiff' => array('image/tiff'),
    'tif' => array('image/tiff'),
    'tar' =>	array('application/x-tar'),
    'tgz' => array('application/x-gzip-compressed', 'application/x-tar'),
    'text' => array('text/plain'),
    'txt' => array('text/plain'),
    'wav' => array('audio/wav', 'audio/wave', 'audio/x-wav'),
    'webm' => array('audio/webm', 'video/webm'),
    'xls' => array('application/excel', 'application/msexcel', 'application/vnd.ms-excel'),
    'xlsx' => array('application/vnd.openxmlformats-officedocument.spreadsheetml.sheet'),
    'xml' => array('text/xml'),
    'xsl' => array('text/xml'),
    'zip' => array('application/x-zip', 'application/x-zip-compressed', 'application/zip'),
);