﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web.Mvc;

namespace DBLocalizationExample
{
    public class MetadataProvider : AssociatedMetadataProvider
    {
        /// <summary>
        /// Create metadata for a model property. Replace text-ids in 'Display' attributes with localized texts.
        /// </summary>
        /// <param name="attributes"></param>
        /// <param name="containerType"></param>
        /// <param name="modelAccessor"></param>
        /// <param name="modelType"></param>
        /// <param name="propertyName"></param>
        /// <returns>ModelMetadata</returns>
        protected override ModelMetadata CreateMetadata(IEnumerable<Attribute> attributes,
            Type containerType, Func<object> modelAccessor, Type modelType, string propertyName)
        {
            var metadata = new ModelMetadata(this, containerType, modelAccessor, modelType, propertyName);
            if (propertyName != null)
            {
                var displayAttribute = attributes.OfType<DisplayAttribute>().FirstOrDefault();
                if (displayAttribute != null)
                {
                    int textId;
                    if (Int32.TryParse(displayAttribute.Name, out textId))
                    {
                        // TODO: get text from database
                        metadata.DisplayName = "DB text with id " + textId;
                    }
                }
            }

            return metadata;
        }
    }
}