﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web.Mvc;

namespace DBLocalizationExample
{
    /// <summary>
    /// A model validation provider that replaces all default model validators with a LocalizableModelValidator
    /// that acts as a wrapper for the original model validator.
    /// </summary>
    public class LocalizableModelValidatorProvider : DataAnnotationsModelValidatorProvider
    {
        protected override IEnumerable<ModelValidator> GetValidators(ModelMetadata metadata, ControllerContext context, IEnumerable<Attribute> attributes)
        {
            var validators = base.GetValidators(metadata, context, attributes);
            return validators.Select(validator => new LocalizableModelValidator(validator, metadata, context)).ToList();
        }
    }
}