﻿using System;
using System.Collections;
using System.Data;
using System.Web;
using System.Web.UI;
using Util;

public partial class Project_Edit : Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        Response.Cache.SetCacheability(HttpCacheability.NoCache);
        Response.Cache.SetNoStore();

        if (!IsPostBack)
        {
            DataRow dr = new DataManager().GetAssignment(Convert.ToInt32(Request.QueryString["id"]));

            TextBoxStart.Text = Convert.ToDateTime(dr["AssignmentStart"]).ToShortDateString();
            DropDownListDuration.SelectedValue = Convert.ToString(dr["AssignmentDuration"]);
            TextBoxNote.Text = Convert.ToString(dr["AssignmentNote"]);

        }
    }


    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        string note = TextBoxNote.Text;
        int id = Convert.ToInt32(Request.QueryString["id"]);
        int duration = Convert.ToInt32(DropDownListDuration.SelectedValue);
        DateTime start = Convert.ToDateTime(TextBoxStart.Text);

        new DataManager().UpdateAssignment(id, note, duration, start);
        
        Hashtable ht = new Hashtable();
        ht["refresh"] = "yes";
        ht["message"] = "Event updated.";

        Modal.Close(this, ht);
    }

    protected void ButtonCancel_Click(object sender, EventArgs e)
    {
        Modal.Close(this);
    }

    protected void ButtonDelete_Click(object sender, EventArgs e)
    {
        new DataManager().DeleteAssignment(Convert.ToInt32(Request.QueryString["id"]));
        Hashtable ht = new Hashtable();
        ht["refresh"] = "yes";
        ht["message"] = "Event deleted.";
        Modal.Close(this, ht);
        //ScriptManager.RegisterStartupScript(this, this.GetType(), "modal", "<script type='text/javascript'>setTimeout(function() { modal.close({refresh:'yes',message:'Event deleted'); }, 0);</script>", false);
    }

    protected void UpdatePanel_Load(object sender, EventArgs e)
    {
        //ScriptManager.RegisterStartupScript(this, this.GetType(), "modal", "<script type='text/javascript'>setTimeout(function() { modal.stretch(); }, 0);</script>", false);
    }


}