using System.Linq;
using Microsoft.AspNet.Mvc;
using Microsoft.AspNet.Mvc.Rendering;
using Microsoft.Data.Entity;
using ASPNET5Demo.Models;

namespace ASPNET5Demo.Controllers
{
    public class StudentMastersController : Controller
    {
        private StudentMastersAppContext _context;

        public StudentMastersController(StudentMastersAppContext context)
        {
            _context = context;    
        }

        // GET: StudentMasters
        public IActionResult Index()
        {
            return View(_context.Students.ToList());
        }

        // GET: StudentMasters/Details/5
        public IActionResult Details(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            StudentMasters studentMasters = _context.Students.Single(m => m.StdID == id);
            if (studentMasters == null)
            {
                return HttpNotFound();
            }

            return View(studentMasters);
        }

        // GET: StudentMasters/Create
        public IActionResult Create()
        {
            return View();
        }

        // POST: StudentMasters/Create
        [HttpPost]
        [ValidateAntiForgeryToken]
        public IActionResult Create(StudentMasters studentMasters)
        {
            if (ModelState.IsValid)
            {
                _context.Students.Add(studentMasters);
                _context.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(studentMasters);
        }

        // GET: StudentMasters/Edit/5
        public IActionResult Edit(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            StudentMasters studentMasters = _context.Students.Single(m => m.StdID == id);
            if (studentMasters == null)
            {
                return HttpNotFound();
            }
            return View(studentMasters);
        }

        // POST: StudentMasters/Edit/5
        [HttpPost]
        [ValidateAntiForgeryToken]
        public IActionResult Edit(StudentMasters studentMasters)
        {
            if (ModelState.IsValid)
            {
                _context.Update(studentMasters);
                _context.SaveChanges();
                return RedirectToAction("Index");
            }
            return View(studentMasters);
        }

        // GET: StudentMasters/Delete/5
        [ActionName("Delete")]
        public IActionResult Delete(int? id)
        {
            if (id == null)
            {
                return HttpNotFound();
            }

            StudentMasters studentMasters = _context.Students.Single(m => m.StdID == id);
            if (studentMasters == null)
            {
                return HttpNotFound();
            }

            return View(studentMasters);
        }

        // POST: StudentMasters/Delete/5
        [HttpPost, ActionName("Delete")]
        [ValidateAntiForgeryToken]
        public IActionResult DeleteConfirmed(int id)
        {
            StudentMasters studentMasters = _context.Students.Single(m => m.StdID == id);
            _context.Students.Remove(studentMasters);
            _context.SaveChanges();
            return RedirectToAction("Index");
        }
    }
}
