﻿using System;
using System.Collections.Generic;
using System.IO;

namespace UnRio.Models
{
    public class BlogArticleRepository : List<BlogArticle>
    {
        public string RootPath { get; set; }
        private string blogFile;

        public BlogArticleRepository(string rootPath, string blogFile)
        {
            this.RootPath = rootPath;
            this.blogFile = blogFile;
            GetAllBlogArticles(false);
        }

        public void GetAllBlogArticles(bool? forceReload)
        {
            if (this.Count == 0 || (forceReload == true))
            {
                this.Clear();
                LoadBlogArticlesFromDataStore();
            }
        }
        
        private void LoadBlogArticlesFromDataStore()
        {
            string[] allLines = File.ReadAllLines(Path.Combine(RootPath,blogFile)); 
            foreach (string line in allLines)
            {
                try
                {
                    string[] allItems = line.Split('|');

                    BlogArticle ba = new BlogArticle();
                    ba.Id = Convert.ToInt32(allItems[0]); //id 1; newest first (top of file)
                    ba.Title = allItems[1]; // "Biggest Tech Article Ever";
                    ba.Category = allItems[2]; //"Tech";
                    ba.RelativeFilePath = allItems[3];// "TechBlog1.htm";
                    ba.Created = DateTime.Parse(allItems[4]); // 2015-03-31
                    this.Add(ba);
                }
                finally
                {
                    // if any fail, just move to the next one
                    // do not stop the app for any reason!
                }
            }
        }

    }
}
