define(function(require){function jSchema(attr){attr=attr||{};const VERSION="0.5.3";var data=[],counter=0,_schema={tables:{},length:0,caseSensitive:attr.caseSensitive===undefined?true:attr.caseSensitive};_schema.add=function(d,metadata){if(typeof d!="object"){_log(1,d+" is not an object");return 0}var name=metadata&&metadata.name?metadata.name.toUpperCase():"TABLE"+counter++;if(_checkUnique(name,this.tables)===false)return 0;if(this.caseSensitive)d=_colToUppercase(d);this.tables[name]={};this.tables[name].id=data.length;this.tables[name].pk=metadata&&metadata.primaryKey?metadata.primaryKey:null;if(this.caseSensitive&&this.tables[name].pk)this.tables[name].pk=this.tables[name].pk.toUpperCase();this.tables[name].rows=d.length;this.tables[name].col=Object.keys(d[0]);this.tables[name].metadata={};this.tables[name].col.forEach((c,i)=>{this.tables[name].col[i]=c;this.tables[name].metadata[c]={dataType:typeof d[0][c]}});data.push(d);this.length=data.length;return this};_schema.get=function(d){if(this.caseSensitive)d=d.toUpperCase();if(_checkForTable(d,this.tables)===false)return;return data[this.tables[d].id]};_schema.join=function(d1,d2,attr){attr=attr||{};if(this.caseSensitive){d1=d1.toUpperCase();d2=d2.toUpperCase()}var target=[];if(_checkForTable(d1,this.tables)===false)return;if(_checkForTable(d2,this.tables)===false)return;data[this.tables[d1].id].forEach(left=>{data[this.tables[d2].id].forEach(right=>{if(left[this.tables[d1].pk]==right[this.tables[d1].pk]){let dest={};for(var attrname in left){dest[d1+"."+attrname]=left[attrname]}for(attrname in right){dest[d2+"."+attrname]=right[attrname]}target.push(dest)}})});this.add(target,{name:attr.name||"WORK."+d1+"_"+d2});return this};_schema.drop=function(d){if(this.caseSensitive)d=d.toUpperCase();if(_checkForTable(d,this.tables)===false)return;data.splice(this.tables[d].id,1);for(var key in this.tables){if(this.tables[key].id>this.tables[d].id){this.tables[key].id-=1}}delete this.tables[d];this.length=data.length;return this};_schema.orderBy=function(d,attr){attr=attr||{};if(attr.clause===undefined)return 0;if(this.caseSensitive){attr.clause=attr.clause.toUpperCase();d=d.toUpperCase()}if(_checkForTable(d,this.tables)===false)return;attr.order=attr.order!==undefined&&attr.order.toUpperCase()=="ASC"?"ASC":"DESC";var orderByData=data[this.tables[d].id].sort(function(d1,d2){return attr.order=="ASC"?d1[attr.clause]-d2[attr.clause]:d2[attr.clause]-d1[attr.clause]});this.add(orderByData,{name:attr.name||"WORK."+d+"_"+attr.clause+"_"+attr.order,primaryKey:attr.clause});return this};_schema.groupBy=function(d,attr){attr=attr||{};if(attr.dim===undefined||attr.metric===undefined){_log(1,"Must include a dimension and metrics to group by");return 0}else{attr.method=attr.method||"SUM";if(this.caseSensitive){attr.dim=attr.dim.toUpperCase();attr.metric=attr.metric.toUpperCase();attr.method=attr.method.toUpperCase()}}var dataset=data[this.tables[d].id];var groupByData=_aggregate(dataset,attr.dim,attr.metric,attr.method,attr.percision);if(groupByData==0)return 0;this.add(groupByData,{name:attr.name||"WORK."+d+"_"+attr.dim+"_"+attr.metric,primaryKey:attr.name});return this};_schema.filter=function(d,clauses){if(this.caseSensitive)d=d.toUpperCase();if(arguments.length<3||arguments.length%2===0){_log(1,"Please include table, predicate, and expression");return 0}let subsetData=data[this.tables[d].id];for(var i=1;i<arguments.length;i+=2){let predicate=arguments[i],expression=arguments[i+1];if(this.caseSensitive)predicate=predicate.toUpperCase();subsetData=_filterPredicate(subsetData,predicate,expression)}this.add(subsetData,{name:"WORK."+d+"_"+arguments[1]+"_"+arguments[2]});return this};_schema.update=function(d,data){if(this.caseSensitive)d=d.toUpperCase();if(_checkForTable(d,this.tables)===false)return;var pk=this.tables[d].pk;this.drop(d);this.add(data,{name:d,primaryKey:pk});return this};_schema.insert=function(d,rows){if(this.caseSensitive)d=d.toUpperCase();if(_checkForTable(d,this.tables)===false)return;if(!Array.isArray(rows))rows=new Array(rows);if(this.caseSensitive)rows=_colToUppercase(rows);rows.forEach(r=>{data[this.tables[d].id].push(r)});return this};_schema.cleanUp=function(){for(var key in this.tables){if(key.indexOf("WORK.")>-1){this.drop(key)}}return this};console.log("jschema.js version "+VERSION+" loaded.");return _schema}function _distinct(d,v){var unique={};var arr=[];for(var i in d){if(typeof unique[d[i][v]]=="undefined"){arr.push(d[i][v])}unique[d[i][v]]=""}return arr}function _checkUnique(d,a){for(var key in a){if(key==d){_log(1,name+" already exists in schema");return false}}return true}function _checkForTable(d,a){if(a[d]===undefined){_log(1,d+" does not exist in schema.");return false}else{return true}}function _filterPredicate(data,p,e){var subset=data.filter(function(d){return d[p]==e});return subset}function _colToUppercase(d){for(var i=0;i<d.length;i++){let a=d[i];for(var key in a){var temp;if(a.hasOwnProperty(key)){temp=a[key];delete a[key];a[key.toUpperCase()]=temp}}d[i]=a}return d}function _log(c,t){let log=["INFO","WARNING","ERROR"],logLvl=0;if(c>logLvl)console.log(log[c]+": "+t)}function _aggregate(dataset,dim,metric,method,percision){var uniqueDimensions=_distinct(dataset,dim);var groupByData=[];method=method||"SUM";if(["SUM","COUNT","AVERAGE","MIN","MAX"].indexOf(method)==-1)return 0;uniqueDimensions.forEach(function(uniqueDim){var filterDataset=dataset.filter(d=>d[dim]==uniqueDim);var reducedDataset=aggregateHelpers[method.toLowerCase()](uniqueDim,filterDataset,metric);reducedDataset.val=reducedDataset.val.toFixed(percision||2);groupByData.push(reducedDataset)});return groupByData}var aggregateHelpers={sum:function(dim,ds,metric){return ds.reduce((a,b)=>{return{dim:dim,val:a.val+b[metric]}},{val:0})},count:function(dim,ds){return ds.reduce((a,b)=>{return{dim:dim,val:a.val+1}},{val:0})},average:function(dim,ds,metric){var reducedDS=ds.reduce((a,b)=>{return{dim:dim,sum:a.sum+b[metric],count:a.count+1}},{sum:0,count:0});reducedDS.val=reducedDS.sum/reducedDS.count;delete reducedDS.sum;delete reducedDS.count;return reducedDS},max:function(dim,ds,metric){return ds.reduce((a,b)=>{return{dim:dim,val:a.val>b[metric]?a.val:b[metric]}},{val:0})},min:function(dim,ds,metric){return ds.reduce((a,b)=>{return{dim:dim,val:a.val===0||a.val<b[metric]?a.val:b[metric]}},{val:0})}};return jSchema});