
/// <binding AfterBuild='MainTask' />

var gulp = require('gulp');
//Using package to minifying files 
ext_replace = require("gulp-ext-replace");

var paths = {webroot: "./wwwroot/"};

//Getting Path of Javascript files 
paths.js = paths.webroot + "js/**/*.js";

//Getting Path of cascading style sheets files 
paths.css = paths.webroot + "css/**/*.css";

//Path to Writing Changed extensions files
paths.Destination = paths.webroot + "Changedextensionfiles";

// Task Name [Changing Extension Javascript]
gulp.task('ChangingExtensionJavascriptTask', function () {
    // path to your files
    gulp.src(paths.js)
   // change file extenstion from .js to .min.js
   .pipe(ext_replace('.min.js'))
   // Writing files to Destination
   .pipe(gulp.dest(paths.Destination));
});

// Task Name [Changing Extension Css]
gulp.task('ChangingExtensionCssTask', function () {
    // path to your files
    gulp.src(paths.css)
   // change file extenstion from css to .min.css
   .pipe(ext_replace('.min.css'))
   // Writing files to Destination
   .pipe(gulp.dest(paths.Destination));
});

//Syntax If you want to run more than one task sequentially
gulp.task("MainTask", ["ChangingExtensionJavascriptTask", "ChangingExtensionCssTask"]);



