﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace webApp.Models
{
    [Table("aspnetusers")]
    public partial class Aspnetusers
    {
        public Aspnetusers()
        {
            Aspnetuserclaims = new HashSet<Aspnetuserclaims>();
            Aspnetuserlogins = new HashSet<Aspnetuserlogins>();
            Aspnetuserroles = new HashSet<Aspnetuserroles>();
        }

        [Column(TypeName = "varchar(128)")]
        public string Id { get; set; }
        [Column(TypeName = "int(11)")]
        public int AccessFailedCount { get; set; }
        [Required]
        [Column(TypeName = "varchar(4)")]
        public string ApsNr { get; set; }
        [Column(TypeName = "varchar(50)")]
        public string City { get; set; }
        [Column(TypeName = "varchar(40)")]
        public string ConcurrencyStamp { get; set; }
        [Column(TypeName = "varchar(256)")]
        public string Email { get; set; }
        [Column(TypeName = "tinyint(1)")]
        public sbyte EmailConfirmed { get; set; }
        [Column(TypeName = "varchar(25)")]
        public string FirstName { get; set; }
        [Column("IPSCnr", TypeName = "varchar(20)")]
        public string Ipscnr { get; set; }
        [Column(TypeName = "tinyint(1)")]
        public sbyte? IsActive { get; set; }
        [Column(TypeName = "varchar(25)")]
        public string LastName { get; set; }
        [Column(TypeName = "tinyint(1)")]
        public sbyte LockoutEnabled { get; set; }
        [Column(TypeName = "varchar(255)")]
        public string LockoutEnd { get; set; }
        [Column(TypeName = "datetime")]
        public DateTime? LockoutEndDateUtc { get; set; }
        [Required]
        [Column(TypeName = "varchar(25)")]
        public string NickName { get; set; }
        [Column(TypeName = "varchar(255)")]
        public string NormalizedEmail { get; set; }
        [Column(TypeName = "varchar(255)")]
        public string NormalizedUserName { get; set; }
        public string PasswordHash { get; set; }
        [Column(TypeName = "varchar(25)")]
        public string PhoneNumber { get; set; }
        [Column(TypeName = "varchar(25)")]
        public string PhoneNumber2 { get; set; }
        [Column(TypeName = "tinyint(1)")]
        public sbyte PhoneNumberConfirmed { get; set; }
        public string SecurityStamp { get; set; }
        [Column(TypeName = "tinyint(1)")]
        public sbyte TwoFactorEnabled { get; set; }
        [Required]
        [Column(TypeName = "varchar(256)")]
        public string UserName { get; set; }

        [InverseProperty("User")]
        public virtual ICollection<Aspnetuserclaims> Aspnetuserclaims { get; set; }
        [InverseProperty("User")]
        public virtual ICollection<Aspnetuserlogins> Aspnetuserlogins { get; set; }
        [InverseProperty("User")]
        public virtual ICollection<Aspnetuserroles> Aspnetuserroles { get; set; }
    }
}
