﻿using ContentNegotiationWebAPI.Models;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
using System.Net.Http;
using System.Net.Http.Formatting;
using System.Net.Http.Headers;
using System.Text;
using System.Web;

namespace ContentNegotiationWebAPI.CustomFormat
{
    public class CustomTextFormatter : BufferedMediaTypeFormatter
    {
        public CustomTextFormatter()
        {
            SupportedMediaTypes.Add(new MediaTypeHeaderValue("application/mycustomtype"));
            SupportedMediaTypes.Add(new MediaTypeHeaderValue("text/mycustomtype"));

            // Important to add the below code otherwise if the client request doesn't contain
            // any encoding header, a 500 server error will be thrown
            SupportedEncodings.Add(new UTF8Encoding(false, true));
            SupportedEncodings.Add(new UnicodeEncoding(false, true, true));
        }

        // Queries whether CustomTextFormatter can deserialize an object of the specified type.
        public override bool CanReadType(Type type)
        {
           return type == typeof(Customer);         
        }
        // Queries whether CustomTextFormattercan serialize an object of the specified type.
        public override bool CanWriteType(Type type)
        {
            return type == typeof(Customer);
        }
        // WriteToStream method serializes Customer type by writing it to a stream
        public override void WriteToStream(Type type, object value, Stream writeStream, HttpContent content)
        {
            bool isSame = CanReadType(type);
            Encoding effectiveEncoding = SelectCharacterEncoding(content.Headers);

            using (StreamWriter sWriter = new StreamWriter(writeStream, effectiveEncoding))
            {
                var str = SerializeResourceToMyType((Customer)value);
                sWriter.Write(str);
            }
        }

        private string SerializeResourceToMyType(Customer customer)
        {
            return "Our valued customer " + customer.Name + " lives in " + customer.City;

        }
    }
}