<p align="center">
  <img src="https://www.dropbox.com/s/dhi0o4hfn3n8vtc/logo.svg?raw=1" width="100px">
</p>
<h3 align="center">
  Micromodal.js
</h3>

<p align="center">
  <a href="#">
    <img src="https://img.shields.io/badge/made%20with-love-E760A4.svg" alt="Made with love">
  </a>
  <a href="https://opensource.org/licenses/MIT" target="_blank" rel="noopener">
    <img src="https://img.shields.io/badge/license-MIT-blue.svg" alt="License">
  </a>
  <a href="https://www.npmjs.com/package/micromodal" target="_blank" rel="noopener">
    <img src="https://img.shields.io/npm/v/micromodal.svg" alt="Package version">
  </a>
  <a href="https://travis-ci.org/ghosh/micromodal" target="_blank" rel="noopener">
    <img src="https://api.travis-ci.org/ghosh/micromodal.svg" alt="Build Status">
  </a>
</p>

<p align="center">
  Lightweight, configurable accessible modal library written in pure JavaScript.
</p>

---

<img src="https://www.dropbox.com/s/8g7fr091tk8o62j/micromodal.gif?raw=1" width="100%">

The aim of this library is to make modal dialogs accessible and easy to include in your project with minimum configuration. It's only 1.9kb minified and gzipped (Happy dance 👯) - A tiny library for big change.

**[Demo and documentation](https://micromodal.now.sh/)**

&nbsp;

<a target='_blank' rel='nofollow' href='https://app.codesponsor.io/link/U7SKSneQBRgvgkE68HFbqR1q/ghosh/micromodal'>
  <img alt='Sponsor' width='888' height='68' src='https://app.codesponsor.io/embed/U7SKSneQBRgvgkE68HFbqR1q/ghosh/micromodal.svg' />
</a>

&nbsp;

## Features
✔︎ Toggles relevant aria attributes on open and close   
✔︎ Closes modal on overlay click   
✔︎ Closes modal on pressing the `esc` key  
✔︎ Traps tab focus within the modal  
✔︎ Focuses on the first focusable element within the modal  
✔︎ Retains the focused element state after closing the modal  

&nbsp;

## Installation

**via npm**
```shell
npm install micromodal --save
```

**via yarn**
```shell
yarn add micromodal
```

**via CDN direct link**
```html
<script src="https://cdn.jsdelivr.net/npm/micromodal/dist/micromodal.min.js"></script>
<!-- or -->
<script src="https://unpkg.com/micromodal/dist/micromodal.min.js"></script>
```

**direct download**
```shell
curl -o https://unpkg.com/micromodal/dist/micromodal.min.js
```

&nbsp;

## Release History
* 0.1.1
    * BUGFIX: Fixed issue where validation was not firing
* 0.1.0
    * CHANGE: Released first minor version 😊

&nbsp;

## Contributing

We are always open and invite developers to contribute to Micromodal. We have kept the guidelines and process dead simple, so you invest more time in making modals great again! 🇺🇸

Micromodal follows the [standardjs](https://standardjs.com/) coding standard and is part of our `package.json` file. It will help us to maintain consistency in the codebase.

#### Development setup
1. Clone Github repo `$ git clone https://github.com/ghosh/micromodal.git`
2. Install `yarn` package manager (Read [installation guide](https://yarnpkg.com/en/docs/install#mac-tab))
3. Run `yarn install` in the root folder to install all dependencies
4. Run `yarn dev` to start a dev server. This serves the example directory and live reloads when any files are changed
5. [Optional] Run `yarn build` to build the files for distribution. This is run automatically as a pre-commit hook as well.
6. Send us pull request and chill

&nbsp;

## Licensing
This project is licensed under [MIT license](https://opensource.org/licenses/MIT).

&nbsp;
## Related
- [Microtip](https://github.com/ghosh/microtip) - Modern, lightweight, accessible css tooltip library. Just 1kb.

&nbsp;

## Contact
You can mention us on Twitter for any questions, suggestions or just send us funny GIF. We ♥️ GIF.
#### Tweet some love   ![Tweet](https://cdn4.iconfinder.com/data/icons/flat-brand-logo-2/512/twitter-20.png)
[Tweet](https://twitter.com/intent/tweet?url=https%3A%2F%2Fgoo.gl%2FsEgnBZ&text=Make%20your%20modal%20dialogs%20accessible%20to%20all%20using%20Micromodal.js%2C%20a%20tiny%20library%20for%20big%20change.&hashtags=a11y "Tweet about Micromodal") about Micromodal and help us to spread the message about the importance of Web accessibility and Inclusive design.

&nbsp;

## Contributors

Indrashish Ghosh – [@_ighosh](https://twitter.com/_ighosh) 🇮🇳

Kalpesh Singh - [@knowkalpesh](https://twitter.com/knowkalpesh) 🇮🇳


