<?php

class TextStatisticsTestCMULex extends PHPUnit_Framework_TestCase
{

    /*

        Words failing according to the CMU pronunciation dictionary.

    */

    protected $TextStatistics = null;

    public function setUp()
    {
        $this->TextStatistics = new DaveChild\TextStatistics\TextStatistics();
        $this->TextStatistics->normalise = false;
    }

    public function tearDown()
    {
        unset($this->objTextStatistics);
    }

    /* Test Syllables
    -------------------- */

    public function testSyllableCountFailingCMUWords()
    {
        $this->assertEquals(4, $this->TextStatistics->syllableCount("abalone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abatement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abatements"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("abbatiello"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("abbruzzese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("abed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abeyance"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aborigine"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aborigines"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aboveboard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aboveground"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("abridged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("abruzzese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("absences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("absoluteness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("absolve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("absolves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("abuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acacia"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("academically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("academician"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("academicians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acceding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("acceptances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("accion"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("accompaniment"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("accompaniments"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("accomplice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("accomplices"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("accorded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("accordion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("accuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("achievement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("achievements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("achoa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acknowledged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("acknowledgement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("acknowledges"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("acoustically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("acquaint"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acquaintance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acquainted"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acquiesced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("acquire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("acquired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acquirer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acquirers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("acquires"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acreage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("acuteness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("adabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("adage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("adame"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("added"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("addeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("addled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("adelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("adieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("adjudged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("admired"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("adorabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("advanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advancement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advancements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advantage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advantaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advantageous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advantages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("adventuresome"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advertisement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advertisements"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advertises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("advice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("advisedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advisement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("advises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aegean"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aerobically"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("aerodynamically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aerospace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aerospatiale"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aesthetically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("afanasyev"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("affixes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("affluence"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("affluent"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("afforded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aforementioned"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aforesaid"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("afterimage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aftertaste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ageless"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aggrandizement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aggressiveness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("agius"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("agne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("agonizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("agreement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("agribusiness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aguayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aherne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aiguebelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("airborne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aircoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("airspace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aisle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aisles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("akiyama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alarice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("albertville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("albion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alcoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aldred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aleo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("algeo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("algorithm"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aliases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alicia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("allderdice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("allege"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alleged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alleges"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("allegiances"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("alles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alliances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("allowances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("allspice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("allwaste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alsace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("altarpiece"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("altice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alusuisse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alveolar"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alveoli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alyce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alyea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alyeska"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amabelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amadea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amadeo"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("amaryllises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amazement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amazes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ambled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ambrosial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ambrosian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ambulances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amezcua"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amityville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amorette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amperage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amusement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amusements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amuses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("analyses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("analyzes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anchorage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andalusian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andreoli"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andreoni"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andreotti"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andreozzi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("anette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("angelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("angerer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("angering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("angled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anisette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("annabelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("anne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("annette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("annexes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("announced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("announcement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("announcements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("announces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("annoyance"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("annoyances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("anstice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antaya"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("antiabortion"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("antiapartheid"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antoinette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anyplace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("anzaldua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aoyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("apace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("apiece"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("apologizes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("apotheosis"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("apparatuses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appearances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("appeasement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("appendage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appendages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("appended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appendixes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("applesauce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("appleyard"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appliances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("appraises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("apprehended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("apprentice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("apprenticed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("apprentices"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("apprenticeship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("approached"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("appropriateness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("araya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arbed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arbitrage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arboreal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arceneaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arceo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("archambeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("archambeault"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("archeological"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("archeology"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ardelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("argonne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ariella"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arlette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("armistice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("armitage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("arne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arnelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arnette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arranged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arrangement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arrangements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arranges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arrearage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arrearages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arreola"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("arriortua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arroyo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arseneau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arseneault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("artifice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aryan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ascended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("asiain"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("asian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("asians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("asiaweek"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("assemblage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("assembled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("assertiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("assurances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("astounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("astuteness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("atalaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("atlases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("atonement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("attached"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("attended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("attentiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("attractiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("audette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("audiences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("auguste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("auspices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("authement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("authorizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("auyeung"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("auzenne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("avarice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("avedisian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("avenged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("average"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("averette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("avice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("avowedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("awarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("awareness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("AWOL"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("axes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ayacucho"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ayala"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayars"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ayatollah"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ayatollahs"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Ayatullah"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayerst"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayoub"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ayuso"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ayyad"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("azpurua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("babbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("babette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("babineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("babineaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("babyak"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("backhanded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("backstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("badeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("badeaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("badgering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("badges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baggage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baidoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("balanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("balances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("balboa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baldrige"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("balle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("balles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("balliet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("balyeat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bandage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bandaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bandages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("banded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("banville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baptiste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barbeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barbette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barcia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baribeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barlage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barnette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barrage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barraged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barrages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barrette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barrilleaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barrineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bartlesville"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bartolomeo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("basaldua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("basement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("basements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baskerville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baskette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("basque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("basques"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("basse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bassette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bastille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bastogne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("batches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("batesville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bathe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bathed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bathes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("battelle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("batticaloa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayog"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bayonet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bayonets"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayou"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayuk"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bayus"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bearded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaubien"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauchaine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauchamp"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beauchemin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauchene"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudoin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaudry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauford"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaufort"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaufrere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beaujolais"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaulac"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beaumier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaumont"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaupre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beauregard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beausoleil"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beautician"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauties"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beautiful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beautify"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauty"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauvais"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bebeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("becherer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bedoya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bedraggled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bedrosian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Beetlejuice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("befriended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("befuddled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beidaihe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beiges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beirne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belge"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beliveau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("belle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belleau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bellefeuille"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("belles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belleville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belliveau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bellville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bellyache"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belonged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beltsville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belyea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belyeu"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bemusement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bended"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("benne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bennette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bentonville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beowulf"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bereavement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("berges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("berjaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bernadette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("berneice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bernice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beseiged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("besiege"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("besieged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beske"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bespectacled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("besse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bessette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bethpage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("betrayal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("betrayals"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beverage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beyond"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bibeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bibeault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bicycled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bierbusse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bille"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("billes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bilodeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bilyeu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("binette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("binges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biondi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biondo"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("biondolillo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bionetics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("birthplace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bisque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bissette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bissonette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bissonnette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bistodeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bivalve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bivalves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blanchette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blaske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blazes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bleau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blinded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("blindfolded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blithe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blithely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blockage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("blockages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blouses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blythe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boarded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("boardinghouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bobbette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bobsled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boccia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bocian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boggled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boghosian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bogosian"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("boguslavskaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boileau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boisseau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boissonneault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boldface"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bolle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bolles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bombarded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bondage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bonne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonneau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bonnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonnette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonnibelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bookcases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bookshelves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boomeranged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boonville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boothe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bordeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bordeaux"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("borealis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("borges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("borne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("borneo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("borosage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boscia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bosse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bothe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boudreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boudreaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bougainville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boulette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bounces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bourbeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bourdeau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bourne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bournonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boutelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyack"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("boyajian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyett"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boyington"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boyum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("braces"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("braille"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brailles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bralorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bramlage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bramlette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brancheau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("branded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brasseaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brazeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brazzaville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breakage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breathe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breathed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breathes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breault"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("breaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breezes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brescia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bresette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bresse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bressette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brideau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgeport"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("briefcases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brissette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("britches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brokerage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("brokerages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brokering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brooksville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brosseau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brossette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brousseau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brownsville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruegge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brundage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brundige"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brunelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brunette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bruske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brusque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brusquely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brusseau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("brutalizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brutsche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryans"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryant"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryars"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brydges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bubbled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Bubiyan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buckled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("budreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bulges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bundled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bungled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buoyancy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buoyant"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burbage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burchette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burdette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bureau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bureaucracies"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bureaucracy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bureaucrat"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bureaucratic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bureaucrats"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bureaus"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burlesque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("burne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("burnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burnette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("burrage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("business"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("businesses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("buske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("busse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("butchering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buttonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buyout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buyouts"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("buysse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("byam"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("byars"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("byas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("byassee"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("byerley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("byrne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("byrnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cabbage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cabbages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cabled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cableone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cabooses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cabotage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cacace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caccia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cadences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cadorette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cafe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cafes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cairnes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("caisse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("calif"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("california"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("californian"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("californians"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("calle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("calles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("calves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cambridgeport"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cambridgeside"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cameo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cameos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("camerer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("camille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("camouflage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("camouflaged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("campeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("campion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("campuses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("canadienne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("candace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("candice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cannes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cantrelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("canvases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("capece"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("capelle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("capitalizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cappiello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caprice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("capua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caravelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caraveo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carbonneau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carcione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cardiges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caresse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cariello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carlisle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carnage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carnes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carreon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carrion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carriveau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cartaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cartersville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carthage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cartilage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cartrette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cartridges"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cartusciello"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cassette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cassettes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("caste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("castille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cataloged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cataloguing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("catches"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("categorizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cattaneo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caucasian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caucuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("causes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cawthorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cayuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ceases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ceausescu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ceder"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ceding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("celaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("celeste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("censuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("centerpiece"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("centrifuge"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("centrifuges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ceraceous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cereal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cereals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cezanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chadbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("challenged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("challenges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chalmette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chameleon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("champagne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("champagnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("champeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("champion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("championed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("championing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("champions"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("championship"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("championships"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("changes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chapelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chappelle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("characterizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charasse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charboneau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charbonneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charlemagne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charmion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chasm"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chasse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chaste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chastises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chateau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chateaux"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chausse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chechnya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chechnyan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cheeses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chelette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chenette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cheong"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chequing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cherne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chevette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chevrette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chiyoda"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("choices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chooses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("choreograph"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("choreographed"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("choreographer"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("choreographers"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("choreographic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("choreography"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("choruses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("christabelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chronicled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chuckled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chujitsuya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("churches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cigarette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cigarettes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cilicia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("circled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("circumstances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("circuses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ciriello"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cirincione"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cirrincione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cistercian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cityplace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("claiborne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clairvoyance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clarabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clarette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clarice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clarisse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clarksville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clarrisse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("claudette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clauses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clavette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clayborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("claybourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clayey"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clearances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("clearinghouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cleavage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cleo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cleopatra"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("climaxes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clinician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clinicians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("clodoveo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("closeness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("closes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clothe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clothed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clothes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clubhouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clutches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clyatt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coalesced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coatesville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cobbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coccia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coddled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coercion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cohesiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coinage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cointreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("collage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("collages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("colle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("college"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("colleges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("collegeville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("collette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colleville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cologne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("comanche"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("combativeness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comeaux"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("comedienne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commanded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("commenced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commencement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commingled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commonplace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("compeau"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("competitiveness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("completeness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("complexes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("composes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("compounded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("comprehended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("comprises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("compromises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conceding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("concepcion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("concierge"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("concubinage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("condolences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("conferences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("confidences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confinement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confluence"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confucian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("congruence"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("connely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("consciences"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("constituencies"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("constituency"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("constituent"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("constituents"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("contended"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("continuances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("contrivances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("controversial"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("conveniences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conveyance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conveyor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("convinced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("convinces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cooperage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coppage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corinne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("corne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cornelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cornette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("corresponded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corriveau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corsage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corvette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corvettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coscia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cosette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cossette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cotelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cotroneo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cottage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cottages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("countenanced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("countenances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("counterbalanced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("countercharges"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("counterespionage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coupled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("courage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("courageous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("courageously"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("courteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("courthouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("courville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cousineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coverage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coverages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("covering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coverings"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coviello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cowardice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cowering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crackled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crawfordsville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crayon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crayons"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("creole"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("creoles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creolized"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creosote"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crepeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crevice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crevices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cribbage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cringes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crippled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("criscione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("criticizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crocuses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("crosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crosspiece"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crosspieces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("croteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crotonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crotteau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crowded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cruces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("crucifixes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cruises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crumbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crumpled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crutches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cryan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cubbage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cuccia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cuddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cuddling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cuneo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("curtice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("curves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cuteness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cuyahoga"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cyacq"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cyanamid"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cyanazine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cyanide"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cyanuric"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cyberspace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cycled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cytoplasm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dabbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("daigneault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daleo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("damage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("damaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("damages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("damme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dandeneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("danelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dangled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("daniello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dansereau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("danville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dapice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("darbonne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("darice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("darrelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("darville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("databases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("daya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dayan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dazzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deathbed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deatherage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("debasement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("debrosse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("decapua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("decelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("decelles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("decisiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("decomposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("decoteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("decreases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dedeaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deduce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deduced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("defaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defarges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defelice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("defensiveness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("degaulle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dehoyos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dejarnette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delbosque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deleo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deleon"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("deleonardis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delfosse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delgiudice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delguidice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delicia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delisle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deliverers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delivering"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("delle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delmed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deluccia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delucia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deluge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deluged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("delve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("delves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("demanded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dematteo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("demayo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("demeo"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("demilitarizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("demme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deneault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("denice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("denne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("denomme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("denounced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("denounces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deodorant"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deodorants"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("deoliveira"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("depended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deployable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deranged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("derousse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("descended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("descoteaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deserves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desormeaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("despises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("desselle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("detached"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("deterioration"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("detherage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dettling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deveau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deveaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("develle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devereaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("device"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deyo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deyoe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deyoung"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diagnoses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dianthia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("diaphonia"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("dibartolomeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dibbled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diceon"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("dideoxycytidine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dieringer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dieses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dieters"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("difelice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("differences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diffuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dileo"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("dileonardo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dille"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dimatteo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dimeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dimpled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dinges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diona"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dione"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("dionysius"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disabled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disadvantage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disadvantaged"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disadvantageous"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disadvantages"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disallowances"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disappearances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disassembled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disbanded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disbursement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disbursements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discharges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discloses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discourage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discouraged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("discouragement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("discourages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("discovering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diseases"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disenfranchisement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disengage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disengaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disengagement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("disgrace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("disgraced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disgraceful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disguises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diskette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diskettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dislodged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disloyal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disloyalty"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disparage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disparaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disparages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dispatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("displace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("displaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("displacement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("displacements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("displaces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disposes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disregarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disservice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dissolve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dissolves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("distanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("distances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("distaste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("distasteful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("distended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("distinctiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disturbances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ditches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("divergences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diverges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("divisiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("divorced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("divorces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dodges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doenges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doggedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dolce"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dolle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("donne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doralynne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doraville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dorette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dorice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dOrsay"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dosage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dosages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doubled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doucette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("douville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("downstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doyal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doyel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doyon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("drainage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dralle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dramatizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("drapeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dredges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dressage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dribbled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("droste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dubeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duchenne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duchesneau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dudayev"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duena"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duenas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dukakises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dulcibelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dulle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dumbfounded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dunne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("durette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duryea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dusseau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dusseault"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dwelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dwindled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dyana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyane"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dyansen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dyatron"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dyazide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyess"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("easement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eases"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("eastes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("eau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("eaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("edifice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edithe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edythe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("effectiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("efficiences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("effluent"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("egerer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Ehud"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eldred"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("electrician"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("electricians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("electrospace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("elle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellesse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("elusiveness"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("elves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("embed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("embedded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("embezzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("embrace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("embraced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("embraces"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("embryology"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emerges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emeryville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eminences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("emlynne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("emme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emphases"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emphasizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emplacement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("employable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("employee"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("employees"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("empowering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enabled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("encircled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("encourage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("encouraged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("encouragement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("encourages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("encroached"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("endangering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("endorsement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("endorsements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enfeebled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enforced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enforcement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enforces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("enfranchises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("engage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("engaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("engagement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("engagements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("engages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enhanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enhancement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enhancements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enhances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("enjoyable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enlarges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ennes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enrage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enraged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enriched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ensconced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enslavement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("entangled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("enterprises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enthuses"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("enthusiastically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("entice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enticed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enticement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enticements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("entourage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("entranced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("entrances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("entrenched"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("envisage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("envisaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("envisages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eocene"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eoff"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eohippus"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eolande"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eons"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("epitomizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("erases"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("erne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("escapement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("espionage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("espouses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("essayist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("esse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("este"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("estelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("estranged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("estrangement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("etches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ethereal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ettlinger"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("etzioni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eudocia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eunice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eurasian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("europeenne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("euroyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eustace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eustacia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eustice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("evansville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("evenhanded"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("evenhandedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("evidenced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("evidences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evinced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evolve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evolves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evonne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("exchanged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("exchanges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("excises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("excitement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("excoa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("excuses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("exercises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("exes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("expanded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("expended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("exposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("expounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("expunged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("extended"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("extraordinaire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eyerman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ezelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fabled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("faceless"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("faces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("facteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("falardeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fangled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fantasizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fariello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("farmhouses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("farnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("faucette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("favreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("faxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fayard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fayez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("faymonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("feces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fecteau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fejes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("felice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("felicia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("felrice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("femme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("feodor"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("feodora"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("feola"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fertilizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fetches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fettes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fetuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fiddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fiddling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fielded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("figaroa"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("figueroa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("filice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("filyaw"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("financed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("financement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("finances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finesse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fingering"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("finne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiona"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("firehouses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fireplace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fireplaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fisette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fishburne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fiske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fitzmaurice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fixes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fizzled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flamboyance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flamboyant"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("flamboyantly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flanges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fleurette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flexes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flounces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flowering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fluency"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fluent"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("flythe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("focuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("folded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("follette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fontenette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fonville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("foodservice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("footage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("footrace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fordyce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forecloses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("foretaste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forgette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forgione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forgiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("formalizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fornes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forsythe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forwarded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("founded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("foxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fradette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fragrances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("franchises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("francia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("francisville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frazzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frechette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freckled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freezes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fregeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frenette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freons"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("freyermuth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fringes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("friona"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("friscia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("friske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fromme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frontage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fryar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuchsias"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fujiya"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fujiyama"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fukuyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fumbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("funded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("furches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("furloughed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("furnace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("furnaces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("furuya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fuselage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fuselages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuzes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gabriella"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gabrielli"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gaccione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gainesville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galarneau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("galileo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galipeau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("galle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galleon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galleons"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("galles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galyean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gamage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gambled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gamboa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gammage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ganglionic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("garages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garbage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garceau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gardea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gareau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garneau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("garnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garnette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garrette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gases"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gasque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gastineau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gaudette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gaudreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gauges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gaulle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gauthreaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gautreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gautreaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gauvreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gazelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gazelles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gazes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gazette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gearboxes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gedeon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("geers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gelette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gelineau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gelles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gemayel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gemme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gendreau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("genoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("geo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geocentric"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geochemistry"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geodesic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geodesy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geodyne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geoffrion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geoffroy"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geographer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geographic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geographical"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("geographically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geography"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geologic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geological"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geologist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geologists"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geology"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geomagnetic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geometric"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geometrical"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geometries"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geometry"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("geomorphology"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("geon"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geophysical"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("geopolitical"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geopolitics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geordie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georg"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("georgeson"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("georgi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("georgiades"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geostrophic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geosyncline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geotaxis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geotek"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geothermal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geotropic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("geotropism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geringer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("geske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("geyelin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gibeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gibeault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gideon"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gieske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giggled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gildea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gilded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gille"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gilles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gillette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gionet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giselle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giudice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glanville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glazes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glenville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glitches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("glowering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gobbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goddeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("godette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goethe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("goldfeder"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("golle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goodreau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gooseberry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gordeyev"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gorgeous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gorges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gossage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goudeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goudreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goulette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goyim"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("graceful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gracefully"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("graceless"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("graces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gracia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("graffeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grambling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("granges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("granville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grappled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grappling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grasse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gravelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gravette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grayish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grecian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("greenhouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("greenpeace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("greenville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grenouille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grievances"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grimaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grimaces"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grimme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grinage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grizzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("groleau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grotesque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grotesquely"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grothe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grotheer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("groupement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grudges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grumbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guardedly"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("guayabera"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guccione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guerette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guerrette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guidice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guilbeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guilbeault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guilbeaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guillemette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guillette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guilmette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gullette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("guste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guyana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guyett"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guyon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guyot"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gvaryahu"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gwynne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("haberer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hachette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haggled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("halcion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("halle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("halve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("halves"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hamme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hammes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("handed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("handedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("handled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hannes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hansche"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("haranguing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hardage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("harleysville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harnage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("harriette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hartlage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hartshorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("haske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hasse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hassled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("haste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hathorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hauppauge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hawthorne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hayashi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hayashida"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hayek"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hayen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hayenga"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hearne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("heavyhanded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heberer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heckled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hedges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heidbreder"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heiges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("helice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("helle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hemme"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hemocyanin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hemorrhage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hemorrhaged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("henne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("henneberry"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hennes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("henriette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hentges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("henthorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heralded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("herbaceous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("herded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heritage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hermitage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("herne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("herriage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("herrlinger"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hesse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hessian"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("heterogeneous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hicksville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hideo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hille"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("himalayan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("himalayas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hindrances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hinges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hirayama"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hiroyuki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("histrionic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("histrionics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hitches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoarded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoarseness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoaxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hobbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hodges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hoelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homage"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("homeostasis"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("homeostatic"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("homme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hommes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("horne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hospice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hospices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hostage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hostages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houdaille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hovering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoyos"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hugely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hugette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hughette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hulette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("humbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hundred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hungering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huntsville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hurteau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hutcheon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huyett"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyacinth"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hyacintha"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hyacinthia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hyacinthie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyacinths"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hyaluronic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hyams"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyannis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hyatt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyena"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyenas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hyperion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hypotheses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyraxes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ianniello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ices"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("iconoclasm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("idea"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("ideological"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ideologies"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ideologists"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("idette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("idled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("idolizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ierne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ignace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("illes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Ilyich"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("image"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("images"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("imbalances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imbedded"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("immortalizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("immunizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("impasse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("impeached"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("impeding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("impounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("improvement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("improvements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("inbred"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("incidences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inconvenienced"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("inconveniences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("increases"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("indecisiveness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("indexes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("indices"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("indonesian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("induce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("induced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inducement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inducements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("induces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("indulgences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("indulges"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ineffectiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inferences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("influence"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("influenced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("influences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("influencing"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("influential"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("influenza"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infrared"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("infringed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infringement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infringements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infringes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("injustice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("injustices"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("innerspace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("innuendo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("innuendoes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("innuendos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("instances"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("institutionalizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("insurances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intended"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("interacciones"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interbred"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("interceding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("interchanges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interface"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("interfaces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interlaced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("intermingled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("interoffice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intervoice"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("intraocular"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("intrauterine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intriguing"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("intriguingly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("introduce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("introduced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("introduces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("inveighed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inventiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("invoice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("invoices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("involve"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("involvement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("involves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iodice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iona"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ionic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ionics"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ionization"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ionizers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ionizing"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ionospheric"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("irette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("irises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ironizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("irvette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("isabelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("isle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("isles"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("isocyanate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Isozaki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("issuances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("itches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jacksonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jandreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janesville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jangled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jarreau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jasmer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaundice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaundiced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaya"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jayashankar"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jeanbaptiste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jeanette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jeanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jeannette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jeansonne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jenne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jennette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jenrette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jeske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jetborne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jeyaretnam"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joffrion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jolette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joliet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jolivette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jopling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jorge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("josette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joshua"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jostes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jostling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joyal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joyoni"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joyous"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("juan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juana"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("juanita"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juarez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("judaism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("judea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("judeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judgement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judgements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judgeship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judgeships"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juggled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jukebox"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("julia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("julianne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("juliet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("julius"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jumbled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jumonville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("junette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("junior"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("juniors"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("justice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("justices"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kageyama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kamerer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kanghua"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("karges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("karnes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kasmer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("katayama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kayak"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kayaking"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kayaks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kayo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kemerer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keogh"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keohane"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kerestes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kernes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kerrville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("keske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keynesian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kibodeaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kidded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kiessling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kilborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kilbourne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kimche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kindled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kindred"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kingsville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kinne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kissling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kitchenette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kiyoshi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kiyotaka"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("klages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kleinpaste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("klemme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("knicely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("knoxville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kobayashi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kocian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kolle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("Komsomolskaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("korfhage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kothe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("koyo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kramme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krammes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("krasnoyarsk"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krausse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kresge"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kresse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krumme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kuenheim"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kuenstler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kuenzi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kunayev"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("labeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("labelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("labranche"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lacayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lachapelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lacoste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lacrosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ladled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lafalce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laflamme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lafollette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lafosse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lagesse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lajeunesse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakeside"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamarche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lambaste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lambastes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lamme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamontagne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamoreaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lamothe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamoureaux"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lanceolate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lancia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("landed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("landreneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("langhorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("language"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("languages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lanouette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lapage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("larche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("larded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lareau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("largesse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lariccia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("larochelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lasalle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lashua"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("laske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lasseigne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("latches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("latendresse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lateness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("latexes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lathe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lathes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("latourette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lattice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laurette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laurice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lausanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lavelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laverne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lavette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lavigne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laviolette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lawhorne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lawrenceville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layered"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("layering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layoff"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layoffs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("layouts"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("layover"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("layovers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leadville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leakage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leatrice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leavelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lebeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ledges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ledonne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("legette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("legged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leggette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("legitimizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leifeste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lemelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leoma"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leominster"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leona"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leonardo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leonel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leonerd"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leones"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leonhard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leoni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leonid"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leonora"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leonore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leontine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leopold"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leopoldine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leopoldo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leotard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lepage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lerette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lesage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("leske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lespinasse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leticia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("letourneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lettice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lettuce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leveille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leverage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leveraged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leverette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("levering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("levesque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lianne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("liberace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("libya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("libyan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("libyans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("licences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("licorice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lighthouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("likeness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("likenesses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lilyan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("limoges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lineberry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lingering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linkage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("linkages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("linne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lionberger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lionel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lionetti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lionheart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lionized"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lirette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lisette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("liske"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("literaturnaya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lithe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("littlepage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("loathe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("loathed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lodges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loewe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("logarithm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("logician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loguidice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loiselle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lonesome"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("looses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lorette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lorne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("losoya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("louisville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lounges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lovage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lovering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lovette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lowering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loyal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyalist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyalists"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loyall"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyally"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyalties"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyalty"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loyola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lozeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lozenges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lozoya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lucerne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lucette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lucia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lucian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lucille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lucrecia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("luelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luggage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lunges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lurches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lurette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lyall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lyell"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lyerla"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lynette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lynne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mabelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("macfadyen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("macioce"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("macroeconomic"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("macroeconomics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("macrophage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("macrophages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("madelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mademoiselle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maffeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("magician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("magicians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mahayana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mahe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mailboxes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("maille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mainville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("majette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("makeover"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("makepeace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malayan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malaysian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malaysians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maleness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("malice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("malle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mallette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malpractice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("malveaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("managed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("management"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("managements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("manages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mandeville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maneuvering"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maneuverings"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("manganiello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mangement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mangione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mangled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("manhandled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("manne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mannes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manseau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mantua"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("manuevering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marantette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maranville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marceau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marceaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marcelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marcia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marcille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marcoses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("margette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("marginalizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marianne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mariette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marketplace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("marketplaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marlette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marmion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marseille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("martelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("martineau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maruyama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maruyu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marvelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maryann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marysville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maryville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marzette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("masaya"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masayoshi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masayuki"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mascia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masiello"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("maske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("massacred"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("massage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("massaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("massages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("masse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masterminded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("masterpiece"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masterpieces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mataya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("matches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mateo"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("materializes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mathe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mathematician"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mathematicians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("matherne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("matisse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("matteo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mattice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maurice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mauriello"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mauthe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maximizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maybelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayeda"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayernik"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayerson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayeux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayonnaise"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayoral"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mayoralty"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mayorga"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayors"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mayville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mazes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mazzeo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcbryar"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mccarville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcconville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mcfadyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcginnes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mckeon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mckeone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mckeown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcneece"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcneice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcquaid"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcquaide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcquaig"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcquain"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("measurement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("measurements"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("medea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("megahouses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mehitabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meiyuh"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("melanesian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("melbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("melded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("melisse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("melle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("melville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("menace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("menaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("menaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meneses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("menezes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("menges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("menne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meow"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mercedeses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("merdyce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("merges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("merhige"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mersereau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mertice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("message"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("messages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("messiaen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("messineo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meteor"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("meteoric"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("meteorological"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("meteorologist"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("meteorologists"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("meteorology"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meyerhoff"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meyering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meyerman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("meyerowitz"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meyerson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meyo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meyohas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("micheaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("michelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("microage"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microamerica"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microeconomic"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microeconomics"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microelectronic"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microelectronics"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("microelettronica"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("micromanage"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("micromanagement"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microorganism"));
        $this->assertEquals(8, $this->TextStatistics->syllableCount("micropaleontology"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("midges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("midgette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("midpriced"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("miesse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("migneault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("milbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mildred"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mileage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("millage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("millette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("milliet"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mimeograph"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minasian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minassian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mindedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mineo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mineola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mingled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("minibuses"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("minichiello"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("minimizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mintage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mirabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mirage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mirelle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miscayuna"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mischarges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mishandled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("misjudged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("miske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mismanaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mismanagement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mismatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("misplace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("misplaced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mispriced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("misstatement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("misstatements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("misuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mixes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyagawa"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyahara"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("miyako"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyamori"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyamoto"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyasaki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyasato"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyashiro"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyazaki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miyazawa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mizelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moccia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("modisette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("molded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("molineaux"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("molle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("molyneaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("momayez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moncayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("monceaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mondeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("monette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mongeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mongering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mongooses"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("monopolizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("monroeville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("montage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("montagne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("montemayor"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("montesdeoca"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("montevideo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montoya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montreal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("montville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moragne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morisette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morissette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moriya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morneault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morreale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morrisette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morrissette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morrisville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mortage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mortages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mortgage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mortgaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mortgages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mortician"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moselle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mosque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mosques"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mousse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mousseau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mouthed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mouthpiece"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mouthpieces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("movement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("movements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mozelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Muammar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muffled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mughniyeh"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mugniyah"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mullineaux"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("multilayered"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("multivalve"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("multiyear"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mumbled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mumme"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("murayama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muscled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("musician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("musicians"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("muske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mustached"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muzzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("myatt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("myelin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("myreon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("myrtice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nadeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nagoya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nairne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nakayama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nanette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("naperville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("napoleon"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("napoleonic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("narayan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("narayanan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("narcisse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nardiello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nashua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nashville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nathe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("navarette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("navarrette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Nazarbayev"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("neault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nechayev"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("necklace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("necklaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nedeau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nederlandsche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("needled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neises"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nelles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nellette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neoclassic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neoclassical"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("neoconservative"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("neoconservatives"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neola"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neoliberal"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neoliberals"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neoma"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neon"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neonatal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neons"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neophyte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neophytes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neoplasm"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neoplatonic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neoplatonist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neoprene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neoprobe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neotenic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neoteny"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nerice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nerves"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("neste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("netterville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neuroses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neutralizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neuville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neveau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("newfangled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("newlywed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("newville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nguyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nibbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nicely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("niceness"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("nickelodeon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nicolette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nicolle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nicorette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nieces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nietzsche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nightstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nilges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nilles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ninette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nishiyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nixes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noblesse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nobuyuki"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nodded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nolette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nonbusiness"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("noncontroversial"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nonesuch"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nonetheless"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nonmanagement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("norcia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("norville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("notches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("notice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noticed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("notices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nottage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nouveau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nouvelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("novice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("novices"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("novoa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noyola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nuanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nuances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nucleonics"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nucleotide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nudges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nuisances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nureyev"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nyack"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nyenhuis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nyerere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oakville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("obeirne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oblige"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("obliged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obliges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obryan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obryant"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("observances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("observes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("obstetrician"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("obstetricians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("obyrne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("occhoa"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("occurrences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ochoa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("odea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("odelette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("odeon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("odette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("oesterreichische"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("offended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("office"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("offices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("offstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ogled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ohanesian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("OHara"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ohbayashi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("olayan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oleo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("olivette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("omnibuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oneness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oneok"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("onstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oozes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("opposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("opticians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orabelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oranges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ordinances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oreffice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orefice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oreo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("organelles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("organizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orgasm"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("orifices"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("orne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orphanage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("orphanages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("orville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("osage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("osages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("osborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("osbourne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("osceola"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("osteopathic"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("osteoporosis"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("osterreichische"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ouelette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ouellette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ounces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outhouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outpace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outpaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outpaces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outplacement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outrage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outraged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outrageous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("outrageously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outrages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outweighed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ovalle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overcharges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overcrowded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overdoses"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("overextended"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overfunded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("overpriced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overproduce"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overproduced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("overreached"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overseer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overseers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oversizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overstatement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overstatements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oyen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oyola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ozanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ozelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("paccione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("package"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("packaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("packages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("padded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paddled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("padua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pagette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("paille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("palace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("palaces"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("paleobotany"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paleocene"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("paleontology"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("palette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("paniccia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pantaleo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pantheon"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("panzhihua"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("papaleo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papayas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papua"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paradoxes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paraguayan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paralyzes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("parazoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("parcplace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parentage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parenteau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("parentheses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pariseau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parisian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parizeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("parlette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("parnes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parsonage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("partridges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pascua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("paseo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("paske"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("pasquariello"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pasque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("passage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("passages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("paste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pastes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("patches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pathe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("patrice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patricia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patrician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patricians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patronage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paulette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pauses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pavement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pavements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("payable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("payables"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payeur"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payoff"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payoffs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("payola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("payouts"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peaceful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacefully"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pebereau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peerage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peladeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pelayo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pelle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("peloponnesian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("penalizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peonies"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peons"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peony"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("peoria"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("percentage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("percentages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("perches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("performances"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("permissiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pernice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perplexes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("perreault"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("perriello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("persian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("persians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pervasiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("petroleos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("petrossian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phalanges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phantasm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phileo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phoenicia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phoenician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phoenicians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phrases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("physician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("physicians"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("phytogeography"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("picariello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("picayune"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("piccione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pichette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pickled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("picturesque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pieces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("piet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pilferage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pilgrimage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pilgrimages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pillage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pillaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pillages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pincavage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pineau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pineo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pinette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pinneo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pinsoneault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pioneer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pioneered"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pioneering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pioneers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("piontek"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("piontkowski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pirouettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pitches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("placement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("placements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("placencia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("places"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plaguing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plainclothes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plascencia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plasencia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plasse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plateau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plateaued"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("playa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("playoff"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("playoffs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pleasantville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pleases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pledges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("plisetskaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plodded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plumage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plumages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plunges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pluses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("police"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("policed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("polices"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("policewoman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("politeness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("politician"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("politicians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pollyanna"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("polyacetylene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("polyak"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polyamide"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polyandrous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polyandry"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polyester"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polyesters"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("polyethylene"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("polymerizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("polynesian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pomerleau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pompeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ponsolle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("populace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("porches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("porges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("porpoises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("porsche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("porsches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("portage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("porterages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("portrayal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("portrayals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("postage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("postponement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("postponements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("postrelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("poultices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poundage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pounded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("powerhouses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("powering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("practice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("practiced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("practices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("praises"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pralle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prattville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("preaches"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("preadolescent"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preamble"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prearranged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preceding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("precipice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("predaceous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preeminence"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preeminent"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("preempt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preempted"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preemption"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preemptive"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preexist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preexisted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preexisting"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preexists"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("preface"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prefaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preferenced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preferences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preignition"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preinvasion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preisler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prejudged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prejudice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prejudiced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prejudices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("premed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("premiering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("premises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prentice"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("preoccupation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("preoccupations"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preoccupied"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preoccupies"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("preoccupy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preordained"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prepackaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prerecorded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("presage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("presaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("presages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("presences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("preserves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prestage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prestige"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("presupposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pretended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prevette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("priceless"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prideaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primeaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("primroses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("princes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("princeville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("principled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prindiville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prioleau"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("prioritizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("privette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("proactive"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("probusiness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("procurement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("procurements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prodded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("produce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("produced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("produces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prognoses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("programme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prolonged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prominences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("promises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pronounced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pronouncement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pronouncements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pronounces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("propionic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("proposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("propounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("proscia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prospectuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prostheses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("proteges"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("protozoa"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("protuberances"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("provideniya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("provinces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prudhomme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pruneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prussian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("puleo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pulice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pumice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("purchases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("purges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("purposes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("purves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("purveyor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("purveyors"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("puzzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pyatt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pyeatt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quadrupled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quai"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quaid"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quail"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quails"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quain"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quaint"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quaintance"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quaintly"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quamme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quebedeaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quellette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quenneville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queuing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quintupled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quivering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rabideau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("racehorses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("races"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("racette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rachelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("radborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("radbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("radice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ragged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rahe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rainville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("raises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("raleses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ramage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rambeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rambled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rambling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rameses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rampage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rampaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rampages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ranges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rankled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rapprochement"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("raske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rathburne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rathe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rattling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ravaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ravages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("raya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rayon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rayos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rayovac"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("raytheon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reabsorbed"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reactionaries"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reactionary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reactions"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reaganesque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("realign"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("realigned"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realigning"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realignment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realignments"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realistic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realities"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reality"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("realizable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("realizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reallocate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reallocated"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reallocating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reallocation"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reallowance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("realtor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("realtors"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("realty"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappraised"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reaume"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rebounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("receding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recognizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recommended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recorded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recovering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recycled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("redhanded"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("rediscovering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("redoubled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reduce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reduced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reduces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reemerge"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reemerged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reestablished"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("referenced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("references"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refinanced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("refinances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refinement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refinements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reflexes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("refocuses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("refuge"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refuges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refunded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refuses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("regarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reimposed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rejiggering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rejoice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rejoiced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rekindled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("relaunched"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("relaxes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("releases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("remanded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("remembrances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reminded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reminisced"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reminiscences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("remittances"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("remme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("remolded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("remoteness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("remoulded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("renege"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reneged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("renne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("renounced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reoffer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reoffered"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reoffering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reopen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reopened"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reopening"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reopens"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reorder"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reordering"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reorganization"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reorganizations"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reorganize"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reorganized"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reorganizes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reorganizing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("repackage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("repackaged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("repackages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("repayable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("replace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("replaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("replacement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("replacements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("replaces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reportage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reprice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("repriced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reprimanded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reproduce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reproduced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reproduces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("repurchases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("requirement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("requirements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rescinded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("researches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("resemblances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resembled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reserves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reshuffled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("residences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("resistiveness"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("resolve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("resolves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resources"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("responded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("responsiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("restaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("restatement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("restatements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("restiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("restrictiveness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resurface"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resurfaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("retarded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("retirements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("retrace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("retraced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("retracement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("retrenched"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("retroviruses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reused"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("revelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("revette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("revises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("revolve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("revolves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rewarded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rhapsodizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rheault"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rheaume"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rhetoricians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rhodesian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhythm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rideau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rideaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ridges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riendeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rifled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("righteous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("righteously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("righteousness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rillette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rinne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riposte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ripostes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rippeon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rippled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rises"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("riske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("risse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("riverbed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rivette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("riviello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riyad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riyadh"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riyals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("robicheaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("robideau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("robinette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("robitaille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rocheleau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rochelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rochette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rockville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rodeo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rodeos"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roebling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roeske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rohleder"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rolle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("romances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("romanesque"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("romaniello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("romelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("romeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rondeau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ronne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rosabelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseanne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roseberry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rosse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rossiya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rothe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rototilles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rougeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rouleau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roulette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roulettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rounsaville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rousse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rousseau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rousselle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rowlette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roxanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("royalist"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royals"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("royalties"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("royalty"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("royex"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rozelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rudelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rudeness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rugged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ruggedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rumage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rumbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rummage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rumpled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("russe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("russellville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("russian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("russians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ryanair"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryans"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sabotage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sabotaged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sackville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sacred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sacrifice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sacrificed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sacrifices"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sacrilege"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salemme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("saleswoman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("saleswomen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("salle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salvage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salvaged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("salve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("salves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("samelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sameness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("samoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sampled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sancia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sandage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sanded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sandwiched"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sannes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("santaniello"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("santayana"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("santoyo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sanville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sapoa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sarcasm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sarette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sarkisian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sarkissian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sasse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("satirizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sauces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sausage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sausages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sauternes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sauvage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sauvageau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("savage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("savaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("savagely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("savages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sawaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sawtelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sayad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sayegh"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scaccia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scarface"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("scarves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scherer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schiewe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schnelle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("scholle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sciascia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scolded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sconces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scorpion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scorpions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scotches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scourges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scoville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scrambled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scratches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scribbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scrimmage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scrutinizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scuffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seaborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("searches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sebaceous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seceding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seconded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("secretiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seduce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seduced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seepage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("seethe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("seigniorage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seiyaku"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seiyu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("selle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("selvage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("selves"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("semiautomatic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("semionenkov"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("semmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("senne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sensitiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sentelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sentenced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sentences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seow"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("separateness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sequoyah"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("serves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("service"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("serviced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("services"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("severing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sewage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sewerage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sexes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sfernice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shackled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shaquille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sharpeville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sheathe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sheathed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shelburne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shelbyville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shelve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shelves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shepherded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sherborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sherbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sherburne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shielded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shigeo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("shionogi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shivering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shiyuan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shoelace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shoelaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shortage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shortages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shortchanged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("showcases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("showering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("showpiece"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("showplace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shredded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shreveport"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shrinkage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shuffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shuffling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("siang"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sias"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sibelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sibille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sibling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("siblings"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidekick"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sideline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidelined"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidelines"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sideman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sideshow"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidestep"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidestepped"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sidestepping"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidesteps"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidestream"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidetrack"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidewalk"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidewalks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sidewater"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sideways"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sidewinder"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidewise"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("signage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("silenced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("silences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sileo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("silhouette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("silhouettes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("silverthorne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simeon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simeone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simoneau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simoneaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simonette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("simpleminded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("simplesse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sincavage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Sindayen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("singled"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("singlehandedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sinuses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sithe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sixes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizzled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("skeoch"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sketches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("skewering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("skidded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("skyboxes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("slaughterhouses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("slices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("slippage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("smoothed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("smuggled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("smythe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("snarled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("snatches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sobering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("socia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("softimage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soileau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sokaiya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("solace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soldiering"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("solve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("solves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("somerville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sommerville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sonne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("soothe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("soothed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("soothes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sorbonne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sorcerer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sorcerers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sorice"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sotomayor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sources"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sourrouille"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sovetskaya"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soviet"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("sovietologist"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soyars"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soysauce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soyuz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaceport"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaceship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaceships"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spangled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sparkled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spasm"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("specializes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("speckled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("splices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spoilage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spokeswoman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spokewoman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sponges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sporleder"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spouses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("springerville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sprinkled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squabbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squillace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stabilizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stacia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("staggering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("staircases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stampeding"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stances"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stapled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("starches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("starnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statement"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statements"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stateside"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("statistician"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("statisticians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stayover"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stayovers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("steakhouses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stearne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("steenkiste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stephenville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stereo"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("stereographic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stereos"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stereotype"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stereotyped"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stereotypes"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("stereotypical"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("stereotyping"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sterilizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sterne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("steubenville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stifled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stinnette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stitches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stockbrokerage"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("stockbrokerages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stolichnaya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stolle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stooges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoppage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stoppages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stopwatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("storage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("straddled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("straddling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("straggled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("straitlaced"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stranded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("strangeness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("strangled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stretches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stromme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("struggled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("studded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stumbled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stumpage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sturges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stuteville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("subsidizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("substances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("subsurface"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("subterfuge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suffice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sufficed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suffices"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suffrage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suffragettes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("suggestiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sugiyama"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("suisse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suitcases"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sukiyaki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("summarizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("summerville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("superseding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("supervises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("supposedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("supposes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surcharges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("surette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("surface"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("surfaced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surfaceness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surfaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("surges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surmises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surpluses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surprises"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("surrealisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("surrette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surrounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surtaxes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surveyor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surveyors"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("susanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("susette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suspended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suzanne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suzette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sverige"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("swaggering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("swatches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("swathed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("swinburnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("swindled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("switches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sybille"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("symbion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("symbolizes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("symmes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sympathizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("syringes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tableau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tableaux"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tabled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tackled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tactician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tacticians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("taddeo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tafoya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("taiyo"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("takashimaya"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("takayama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("takeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("talmage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tamayo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tangled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tapering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tasm"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("taste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tasteful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tastefully"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tasteless"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tastes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tauruses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("taxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teases"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tebeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("technician"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("technicians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teenage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teenaged"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("telemanagement"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("televideo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("telexes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("telles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("temme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("teodoro"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("teriyaki"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ternes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("terrace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("terraced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("terraces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("terrorizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("teruya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("teske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tetreault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thaddea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thebeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("themselves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("theo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theobald"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theocracy"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theocratic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theodor"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theodora"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theodore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theodorou"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theodric"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theola"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("theologian"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("theological"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theology"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("theon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("theone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("theophania"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theophila"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theora"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("theoretical"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("theoretically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theorist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theorists"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theorize"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theorized"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theorizes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theorizing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("theses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thibadeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thibeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thibeault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thibeaux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thibedeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thibodeau"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thibodeaux"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("thinnes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("thoennes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thomases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thomasville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thoreau"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("thorne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thoroughbred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("throneberry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tickled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tilles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("timme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tinkled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tithe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("titusville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toddling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("toelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toggled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toggling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tokuyama"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tolerances"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tolle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tolles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tomeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tondreau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tonnage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tonnages"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tonne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tonnes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("toothed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toothpaste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toothpastes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toppled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("torches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("torosian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("torreon"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("torsiello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tortoises"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tortorice"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("tortoriello"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("toshiyuki"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("toste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("touchette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tourangeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tourville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("towering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("townhouses"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("toyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toyo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("toyobo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("toyoda"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toyoo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("toyota"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("toyotas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("traces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tracheophytes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trackage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trageser"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trampled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transcended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transimage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("treatises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trebled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trefgarne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("treharne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trembled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("treon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("triage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tricia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trickled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trieste"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("triggering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tripled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trivette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("trivializes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("troubled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("troyan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("troyanos"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("troyat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("troyu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trudeau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trudges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trundled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tryart"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tsiang"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tsuneo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tuberville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tumbled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tunisian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("turberville"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("turbocharges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turenne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turnage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tussled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tutelage"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("twelve"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("twitches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("udelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ulloa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("umbrage"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("unabashedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unabridged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unacknowledged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unamended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unannounced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unattached"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unattended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unbalanced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unbounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unbranded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unbridled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unchallenged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unchanged"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("uncontroversial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unconvinced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uncovering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("undamaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("underage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("underfinanced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("underfunded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("underhanded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("underprice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("underpriced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("understatement"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("unemployable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unfenced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unfolded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unfounded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unfunded"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Ungeheuer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ungerer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unguarded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unhedged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unheralded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unhinged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unintended"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unionfed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uniroyal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unmanage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unmanaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unnoticed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unpayable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unplaced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unprincipled"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("unreality"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unrealized"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unrecorded"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unruffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unscathed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unshackled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("untouched"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("untroubled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unwavering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("upended"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("upstage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("upstaged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Ural"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("urges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Urquart"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uruguayan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("usage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("usages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("uses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("uthe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("utilizes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Uttar"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("utterances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uyeda"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uyehara"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uyeno"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Uzis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vacaville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valeo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("valle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("valleau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vallely"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("valles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vallette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("valve"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("valves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vanasse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vandamme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanderslice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandewalle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vanhorne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vannguyen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vannice"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanscoyoc"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vantage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vantages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("variances"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("varnes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("varves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vases"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vaske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vaudeville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vaxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vedette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("veillette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("velayati"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("venereal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("venice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("venne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("venturesome"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("verbiage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("verges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("verhage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vermette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("verne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vernes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("verrette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("versace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("versailles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("verville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vestige"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vestiges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vices"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("video"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videodisk"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videodisks"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videogame"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videophone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("videos"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotape"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotaped"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotapes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("videotaping"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotex"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotext"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("videotron"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vienneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("viet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vigneau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vigneault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vignette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vignettes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("village"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("villages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("villareal"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("villette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vincelette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vindictiveness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vingmed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vintage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vintages"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("violation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("violette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("viruses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("visage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vitiello"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("viverette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("viyella"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vizcaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voiceless"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voices"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("volle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voltage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("voltages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voyage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voyaged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("voyager"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("voyagers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("voyages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voyeur"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("voyeurism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vremya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wadded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waffled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waffling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wagering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wages"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("wakabayashi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wallace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("walle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("walles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wallpapering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("walruses"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wangled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wantage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wantages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("warded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("warehime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("warehouse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("warehousing"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("warmongering"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("warne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("warnes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("washburne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wasmer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("waste"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wasteful"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wastes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("watches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("waterbed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("waterborne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("watsonville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wavering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waxes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Wayans"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waynesville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wedded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wedges"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("weisse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("welborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("welded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("welle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("welles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wentzville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wernette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wesleyan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("westburne"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("westfaelisches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weyand"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weyandt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weyant"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("whampoa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wheezes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteside"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitesides"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whittling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wholesome"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wicked"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wickedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wielded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wilbourne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("willabelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("willamette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wille"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("willes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("willette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wilmette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("winborne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("winded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("winne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("winterbourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("witches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wobbled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("woeste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wolle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wolves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("worded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("workplace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("workplaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wounded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wrangled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wreckage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wretched"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wretchedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wrinkled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wristwatches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wyand"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wyant"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wyatt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wyeth"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wynne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wythe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("xinhua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Yanayev"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yardage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yasuyoshi"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yelle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yeo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yeses"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yeske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yevette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yielded"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ying"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yodice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yohe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yokoyama"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yoneyama"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yourselves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("youville"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yuille"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yvette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yvonne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zanoyan"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zaske"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zaslavskaya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zayac"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zayas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeebrugge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zegeer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zelaya"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeoli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zeos"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zieske"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zionism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zionist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zionists"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zises"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ziyad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ziyang"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zoologist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zoology"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zornes"));
        // Stop here and mark this test as incomplete.
        $this->markTestIncomplete(
            'Tests above this line are expected to pass. Tests after this line
            may fail due to code issues, or due to the test being incorrect..'
        );

        $this->assertEquals(2, $this->TextStatistics->syllableCount("aguiar"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aguinaga"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ahmed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aichi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aida"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aidan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aikin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("airedale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aires"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aithne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aiton"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("albanese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("albea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("albeit"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("albemarle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alchemically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aldape"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aldys"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("aleatory"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alehouse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aleksandr"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aleman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aleshire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alethea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alewife"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alewine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alewives"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alfiero"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alfonse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alfonsine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alfred"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("algebraic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("algiers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("algonquian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("algorithms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alguire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alicea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alienate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("allegedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("allegiance"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alleman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("allender"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("almaguer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aloia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aloisia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aloysia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("alphabetically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("alphonse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("altaic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("althea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("altomare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("altruism"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("altruistic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("alvares"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("alysia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amadeus"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amalea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amalia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ambience"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ambient"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ambiguities"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ambitious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ambitiously"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ambler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ambrosine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amelia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ameline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ameliorate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("amerine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ammonia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("amphitheater"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("amphitheaters"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("amphitheatre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("amrhein"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("amyotrophic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("anachronisms"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("anacostia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("analogue"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("analytically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("anatomically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("andean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("andrea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("andreas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("andreini"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("andren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("angeles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("angelically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("angelone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anglen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("angove"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("anguiano"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("annese"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("annuities"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("annunciata"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anreder"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("anse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anstine"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("antagonisms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antares"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("antenne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anthea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("anthes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anthiel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("antigone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("antigones"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("antinuclear"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("antique"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("antiques"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("antiquity"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antisense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("antunes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("anxieties"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("anxiety"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("anxious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anxiously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anyon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("anyone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aoki"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aorta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("apache"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("apaches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("apelike"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aphorisms"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aphrodites"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("apnea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("apocalypse"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("apologetically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appalachian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appalachians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appreciable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("appreciably"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aprea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aquirre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arabe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arai"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arakelian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aravind"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("archaic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("archetypal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("archibeque"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("archimedes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ardine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arduini"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("area"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("areas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arguable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("arguably"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ariel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("armbrister"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("armes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("armine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arnone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("arquette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("arrieta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("artale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("artcarved"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("artistically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ascii"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("asea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("asean"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aseltine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ashe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("asheville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("asiel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("askren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aspires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aspirin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("assembler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("assemblers"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("assicurazioni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("assiduous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("assiduously"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("assuredly"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("astrogeology"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("astronomically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("atheist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("atheistic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("atheists"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("athenaios"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("athletically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("attache"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("attaches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("atteberry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("attebury"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("attire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("audrie"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("aue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("auerback"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("aug"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aurea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("australia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("australian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("australians"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("austroasiatic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("authentically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("automatically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("automoviles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("auxiliary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ave"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("aveline"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aven"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("averages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("averaging"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("aviazione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aviles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("avionic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("avionics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("avions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("awesome"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("awestruck"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("awfully"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("aydelotte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ayodhya"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("babblers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("babyish"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("baccalaureate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bacchanalia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bachelors"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("backe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("backes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("backfired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("backfires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("backfiring"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("backlogged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("baer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baez"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bahre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baidoan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baidoans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baidoas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baiul"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bakeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bakeware"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bakewell"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bakke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("balaguer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("baldassare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("balentine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("balfe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baliles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("balke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ballentine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ballyhooed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("baltes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bandolier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bandoliers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("banjoist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("banke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bankes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("banque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baoguang"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baptisms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baptistery"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barefoot"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bareknuckle"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("barentine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barfknecht"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barkeley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barlettesville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baroque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barres"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barrientes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("barriere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("barthelme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("barthes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bartl"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bartolomei"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bartone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseball"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseballs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseboard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseboards"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("baseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("basically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("basler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("basore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bassler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bateman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bathke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("batte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("battiato"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("batuigas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baudoin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("baumler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bayerische"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bazemore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bbc"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bbq"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beaches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beachler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beaird"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beata"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beato"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beatrice"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beauchesne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beautifully"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bebe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bedient"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beebe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beebes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beforehand"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("begeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("begnoche"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("begonia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("begonias"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("begue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("behavior"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("behavioral"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("behaviorists"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("behaviors"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("behlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("behne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("behnke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("behringwerke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beidler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beiersdorf"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beijer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("beilke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beitler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("belfiore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belgian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belgians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belgique"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("belier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("belke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bellevue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bellone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belongia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belote"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("belshe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("belying"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("benavides"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("benches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bendure"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bene"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("benecke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("benequity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("benes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("benevides"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bengoechea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("benke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("benoist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bente"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beougher"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bequeath"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bequeathed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bequette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("berdine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("berea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beresford"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bergeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bergemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("berghuis"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("berkeley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berkes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("berlascone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("berlottes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bermea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berres"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("berrien"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("berte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bertilde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bertling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bertone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("besler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bessire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bessler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bestiality"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bethea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bethke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beucler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beumer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beutler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("beuys"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("beverages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bewitched"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("biagioni"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("biaxial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bichler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bicycling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biedermeier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biegler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bielke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bieniek"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biennale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("biennial"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bierer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bierly"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("biers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bigler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("billiard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("billiards"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("biologically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("biomed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("biosafety"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bioscience"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("biosciences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("birchler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("birkeland"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("birkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("birle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bitesize"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bitler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bivouac"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bizarre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bizarrely"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bjerke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakeley"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakemore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakeney"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakeslee"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blakesley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blanke"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("blankenbeckler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blaschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("blasia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("blasingame"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("blassingame"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blauer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("blessed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blitzed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blonde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blondes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bloodshed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("blouin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bluest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bluey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bluish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Bnai"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boaz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bodine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boehlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boehme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boehne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boehnke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boening"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boheme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bohlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bohne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boies"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boise"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boleware"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bollettieri"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bolognese"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bolte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bombardier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonaparte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bonde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonebrake"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonecrusher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonecutter"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonenfant"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bonesteel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bonet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonfire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonfires"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bongiorno"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bongiovanni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonneville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bonnevilles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bonsignore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bonte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("booed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bordenave"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bordes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boredom"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("borgia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("borneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bornemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boroian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("borre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bosler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bottler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bottlers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bottone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("bougainvillea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bourgeois"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bourgeoisie"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bourke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bournewood"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bourque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boutique"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("boutiques"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("boutte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bovespa"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bowles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bowne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bowse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bowyer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("boyea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bozeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("braaten"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bracelet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bracelets"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bracewell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brakebill"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brakefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brakeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brakemen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brakke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bramalea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("branches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brandeberry"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brandes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brandl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("braque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brasilia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("braziers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brazilian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brazilians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brcko"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breaches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breezeway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("breitling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brekke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("brendlinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("breneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brennecke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brenneke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brenneman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("brentlinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bressler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("briarcliff"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridegroom"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridesmaid"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridesmaids"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgeforth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgehead"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bridgeton"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bridgewater"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brien"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brierley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brietzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brigadier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brigitte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brigode"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brilliance"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brilliant"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brilliantly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("briones"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bristling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brittian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("brizendine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("broerman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bronze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brookehill"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("brouhard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brouillard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brouillet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brouillette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("browne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("browse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brueggeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brueggemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bruella"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruggeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bruington"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruins"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bruinsma"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brunches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("brunke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("brunnhilde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bruynes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bruzzese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bryon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bt"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bta"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("bucciarelli"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buchler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buckler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("budai"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("budde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buechler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buffeted"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("buffone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bugling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buick"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buicks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bulthuis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bunches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bunde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bundling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bundren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bungling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bunke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("bunte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("bunzl"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("buonocore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buoy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buoyed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buoys"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("burdine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("burdines"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("burke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("burkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("burres"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("burriss"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("businessland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("businesslike"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("businessman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("businessmen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("businesswoman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("busler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bussiere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("bustling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("butare"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("butte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("buttler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("byelorussia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("byington"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("byus"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cabinetry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cabrales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cacao"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caccavale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cacciola"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caceres"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cacioppo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cacique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cackling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cadotte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caesarea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cafiero"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cahouet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caiazzo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caillouet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caiola"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("calabrese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("calame"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("calcote"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("calderone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("calliope"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("calliopes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("caltagirone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("camire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("campanale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("campfire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("campfires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("campione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("canace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("canale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cananea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("candler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cangialosi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("canipe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cannone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cansler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cantone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cantv"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caouette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("capehart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("capetown"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caplinger"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caporale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caracciolo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caradine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cardinale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cardoen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cardone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carefree"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caregivers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carelessness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caremark"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("careplus"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caretaker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caretakers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("caribbean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carinii"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("carleton"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carlone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carlyon"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("carnevale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carnine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carrere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carriages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("carriere"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("carrizales"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("carte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("carusone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("casal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("casale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("casares"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("casciato"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cascone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("casebolt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caseload"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caseworker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caseworkers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cashier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cashiers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("casler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cassese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cassia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cassone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("casstevens"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("castiglione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("castine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("castorena"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cataclysm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("catalogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("catalogued"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("catalogues"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("catalonia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("catanese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("catania"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("categorically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("catharine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("catharines"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cathmor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("catholic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("catholics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("causeway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("causeways"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cautious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cautiously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cautiousness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cavalier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cavaliere"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cavalierly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cavaliers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caveat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("caveats"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("caveman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cawsl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cazares"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cd"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cdebaca"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cecelia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cecere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cecilia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cedrone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("celestine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("celia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("celosia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cenozoic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("centerre"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("centurion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cercone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ceres"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cerone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cerrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cervone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cesare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cespedes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cevaxs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chaidez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chairez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chandelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chandeliers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chaos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chaotic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chappuis"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("characteristically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charest"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("charles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charleston"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charlestown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("charlotte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charlottesville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charlottetown"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("charpentier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cheeseburger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cheeseburgers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cheesecake"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cheeseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chemed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chemically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chengxiang"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cheque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cheques"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chesler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chevalier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chevrier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chianese"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chiang"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chiappone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chiara"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chicagoans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chihuahua"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chikane"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("childe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chile"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chilean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chileans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chisler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chiu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chloe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chmiel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chmielewski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chmura"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chocolat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chocolate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chocolates"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("choiniere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("choir"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chopsuey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("choquette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("chortling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chouinard"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chrismer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("christiana"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("christiane"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("christianity"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("christiano"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("christophe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("chronologically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chrzan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("chrzanowski"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chseing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("chuang"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("chui"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ciaccia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ciaccio"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciampa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciampi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cianci"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ciancio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cianciola"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cianciolo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cianciulli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciani"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ciaobella"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ciaramella"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ciaramitaro"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ciaravino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciardi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciarlo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ciavarella"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cicalese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ciccone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cicely"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cinque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciocca"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ciolino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciotti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("circling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("circuitous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("circumference"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cirque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cityfed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciucci"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciulla"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ciullo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("civilian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("civilians"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("claremont"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clarion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clarke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("classically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cleah"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cleanse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cleaveland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cleveland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("clevelanders"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clevetrust"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cliche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cliched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cliches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clinches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("clique"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cliques"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cloey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("closedown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("closedowns"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clotheshorse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clothestime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clothier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clothiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clothilde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clouatre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cluett"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("clydesdale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cmon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cmos"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cmx"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coaches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coady"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coale"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coalson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coates"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coaxed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coaxum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cobbler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cobblers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cochlea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cochlear"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cocke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cockroaches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coderre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coeds"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("coeducational"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coefficient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coefficients"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coelho"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coello"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coenen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coenzyme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coequal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coerce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coerced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coercing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coercive"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coeur"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coexist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coexisted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coexistence"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coexisting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cogema"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coglianese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cohea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coincide"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coincided"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coincidence"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coincidences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coincident"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coincidental"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("coincidentally"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coincides"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coinciding"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coinsurance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cojuangco"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("colaianni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coldren"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colebank"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colebrook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colegrove"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coleman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coleridge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coleslaw"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("colestipol"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colestock"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coleus"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coliseum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("collapse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colleague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colleagues"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("collegians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("collegiate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("collier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colliers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("collodion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("colloquial"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("colloquium"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colonel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("colonels"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("colorfully"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("colosseum"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("colourful"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("comanches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("combe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("combes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comeback"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comebacks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comedown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("comfed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("commemorative"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("commercebancorp"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("commerciale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("commerical"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("commingling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("complementary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("comrie"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("comunale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("concorde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("conde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("condense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("condren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("condry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conduit"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conduits"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coneflower"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conferencing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("confidante"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("confidentiality"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("confucianism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("congenial"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conquer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conquers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("consequences"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conserved"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("consortiums"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conspire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("conspired"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("construcciones"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("contagious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("contagiousness"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("conte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("contemptuously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("contentious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("contentiousness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("continuum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("converged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("conyers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coogler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coombe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("coombes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cooperate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cooperated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cooperates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cooperating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cooperation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cooperations"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("cooperative"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coordinate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coordinated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("coordinates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coordinating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coordination"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coordinator"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("coordinators"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("copeland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("copeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("copiague"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coplen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("copytele"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corbusier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cordes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cordial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cordially"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cordry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("corestates"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("coretech"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Corleone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cornea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corneas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cornelia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cornelius"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("corporacion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corporatewatch"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("corporatewide"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("corpse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corrales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("correa"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("corte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cortes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cortese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("corzine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cosme"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cosmetically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cothren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cotler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cotrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cottone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("couches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("couillard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("couldnt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("courchesne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("courtemanche"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coval"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coyote"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("coyotes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cozine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("crabbe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cradling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cranesbills"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creager"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("create"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("created"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("creates"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creating"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("creationism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creations"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creative"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("creatively"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("creativity"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creator"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("creators"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("creer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("creque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cressler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crimea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crisler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cristiani"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cristiano"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("criterion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("criticisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("critique"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("critiques"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crnkovich"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("croat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("croatia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("croatian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("croatians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("croats"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("croce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crocheted"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cronauer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cronyism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crooked"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("crounse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crovl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crovls"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("crowne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crownx"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crozier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cruea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cruel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cruey"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cruikshank"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crumpler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("crunches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cryolite"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("crysler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("csaszar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cuddeback"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cuello"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("cuffe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cuneiform"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cunliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cureton"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("curiale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("curnutte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cutaia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("cutesy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cutrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cuvelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cxc"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cyclades"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cycling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("cyclist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cyclopean"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("cytherea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dadeland"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dahlia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dahlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dahnke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daiichi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dalgleish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dalia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dalke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daloia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dalpe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dambrosia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("damewood"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("damien"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("damietta"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dandelion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dandelions"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dandrea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dandyism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("danese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dangler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dangling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daniele"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dannemeyer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("danske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("daoud"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("daoust"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daredevil"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("darien"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("darke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("daseke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dassler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("datapower"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dateline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("datelines"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("davide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dbase"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ddt"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("deactivated"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dealba"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deana"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deanda"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deandrade"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deandrea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deangelis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deanna"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("debiase"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("debora"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deborde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("debruin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("debutante"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("debutantes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("debuted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("decesare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("declerque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("decorative"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("deemphasizing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("deer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("defense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defenseless"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("defiore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("defrates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("degaetano"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("degeorge"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("degiacomo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("degrace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("degrave"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deguire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("degutare"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dehne"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("deification"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deify"));
        $this->assertEquals(9, $this->TextStatistics->syllableCount("deinstitutionalization"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deisher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deities"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delatte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delaurentiis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delbene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delcine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delebarre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delfine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delgiorno"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("delia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delineate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("delineated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delineates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("delineating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("delineation"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deloitte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delorean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delores"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delosreyes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("delphine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delpriore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("delre"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("delsignore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deltaic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deluise"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("demagogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("demagogues"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("demarest"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dementia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("democratically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("demographically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("denarii"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("denatale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dengler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("denlinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("denouement"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dense"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("densely"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dente"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("denuclearization"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("denuclearized"));
        $this->assertEquals(8, $this->TextStatistics->syllableCount("deoxyribonucleic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dep"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("depace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("depascale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("depasquale"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("deppe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("depreciable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("depriest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dercole"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("derflinger"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("derosia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("derouen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("derouin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desai"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("desantiago"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("descartes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("deschler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deserved"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("deservedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deshaies"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("desimone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("desiring"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deslatte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("desperate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("desroches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dessauer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("detente"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("determinedly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("detore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dettore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deutschemark"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("deutschemarks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("devilish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devillier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devour"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devoured"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("devouring"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("devours"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dewilde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dewitte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dewolfe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dhlakama"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diabetes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dialogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dialogues"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diamond"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diamonds"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dianne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diaper"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diarrhea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diastole"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dibiase"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dicesare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dichroic"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dickes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dicomed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("didion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diego"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diener"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dienst"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dierkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dierking"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dietary"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dietetic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dieting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dietitian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dietitians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dietl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diets"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("Dieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diez"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("differentiate"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("differentiated"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("differentiates"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("differentiating"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("differentiation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("differently"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("difiore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("digiacomo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("digioia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("digiovanna"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("digiovanni"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("diguglielmo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("diianni"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diiorio"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dikeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dildine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diltiazem"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dimare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dimichele"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dinatale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dinehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dingler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dinmukhamed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dinse"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("dionisio"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("diorio"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dipaola"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dipaolo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dipasquale"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("diplomatically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("directv"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dirkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dirkse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("discharged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("discotheque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dIsere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("disgorged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("disgorgement"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disgruntling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disimone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disinterested"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dismantling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("disorient"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("disorientation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disoriented"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("disorienting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dispatched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dispense"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("disque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dissuade"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dissuaded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("diverged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("divulged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dk"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dlouhy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dlugos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dlugosz"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dmitri"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dobrzynski"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("doepke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("doer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doerfler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("doerflinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doering"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dogmatically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dohme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dohse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dolores"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("domangue"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("domestically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("domine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("domingue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dominique"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("domke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("donde"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dondlinger"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("donze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doonesbury"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("doppler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dorea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dorine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dorion"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dornier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dorothea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dorthea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dosia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dossier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dossiers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doubtfire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("doubtfires"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("douglass"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dour"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dovetail"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dovetailed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dovetails"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dower"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dowers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("downe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("downes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dowse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dramatically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("drastically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("drawer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("drawers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("drechsler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("dreher"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dressler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("driveway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("driveways"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("drogue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("drouillard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("drouin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("druella"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("druid"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("druidism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("druids"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dsouza"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dualisms"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("duane"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duarte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dubilier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dubreuil"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dubuque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ducharme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duelist"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duels"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duets"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dufresne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dukedom"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dukeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dulcea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dulciana"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dulcinea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dullea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dumire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duncombe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dunmire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("duodenal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duong"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("duopoly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dupler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dupriest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dupuis"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("duque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duquesne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("duquette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duramed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("durflinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duvalier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("duvaliers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dwindling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dyches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("dykeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("dyslexia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("dzhirkvelov"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eagleye"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("earle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("earles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("easudes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eavesdrop"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eavesdropping"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eblen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("eckes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eckl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eclipse"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ecologically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("economically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ecstatically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ecuador"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ecuadoran"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ecuadorian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgecomb"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgecombe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgemon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgeways"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgewood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("edgeworth"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("edinburgh"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("edizione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("edouard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("edrea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("edrington"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eduard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eduardo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("effler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("egoism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("egregious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("egregiously"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ehle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ehlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ehrke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eichler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eiermann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eifler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eightieth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eiichi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eiseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eisemann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ekkehard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("elaborate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("elaborately"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("elapse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("elbe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("electricite"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("electrique"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("elementary"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("eleonore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("eletr"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("elinore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("elkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellerbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellesmere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ellipse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ellithorpe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("elmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("else"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("elsea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("elsevier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("elsewhere"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("elysia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emanuel"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("emanuele"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("embler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("embolisms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("embryo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("embryonic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("embryos"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("emde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("emerald"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("emeralds"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("emerged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eminase"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emmaline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emmanuel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emotionally"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("emphatically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emphysema"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("empire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("empires"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emslie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("emuil"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("encarnacion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("encircling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("encroaches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ende"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enea"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("energetically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("engelke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("engeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("engler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enholme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("enke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("enlarged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enlargement"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enlargements"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ennea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ennui"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enriches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("enslen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ensminger"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("enthusiasm"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("enthusiasms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("entire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("entirely"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("entitling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("entrenches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("entringer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("entsminger"));
        $this->assertEquals(8, $this->TextStatistics->syllableCount("environmentalism"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("epicurean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("epilogue"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("epitome"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("eppes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eppler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("equiangular"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("equity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eranthe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("erbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("erbes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ercole"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("erion"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eritrea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eritrean"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("erratically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("erte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ertl"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("erythropoietin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("esler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eslinger"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("esme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("espalier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("espe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("especially"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("esquer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("est"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("esteves"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("etc"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ethnically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ethyol"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("etiquette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("euan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("euchred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("euclea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("eudosia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("euphemisms"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("euphemistically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("euphrates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("euromissiles"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("euromobiliare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("european"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("europeans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("europewide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eveland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evening"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("evenings"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("everybody"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everyday"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everyman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everything"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everytime"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("everywhere"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("evidentiary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("exchequer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("expanse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("expeditious"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("expeditiously"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("expense"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("experience"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("experienced"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("experiences"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("experiencing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("expires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("eyepiece"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("facedown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("facelift"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("facemire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("facetious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("facetiously"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("faciane"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("facsimile"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("facsimiles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fagundes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fahnestock"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("faiola"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("faist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("falcone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("falke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("false"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("falsehood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("falsehoods"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("falsely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("falzone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("famiglietti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("familial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("familiar"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("familiarity"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("familiarize"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("familiarized"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fansler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fantastically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fanueil"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("farace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("faraone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("farese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("farewell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("farewells"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("farfetched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("farquhar"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("farruggia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("farrugia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fasone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fassler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fatigue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fatigued"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fatigues"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("faubion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("favale"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fawkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fayetteville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("FDIC"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fealty"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("feb"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("felde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("felske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("feltes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fencl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fenske"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ferraioli"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ferre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ferriss"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ferrofluidics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ferrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fessler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiance"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ficke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fickes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fictitious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fidelia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fidler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fieros"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fiers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiery"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiesta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiftieth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("figler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("figueira"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("figueiredo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("figurehead"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fildes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("filenet"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fillingame"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("finale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("financier"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("financiera"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("financiero"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("financiers"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("finanziaria"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finarte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fincke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("findling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fineberg"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finefrock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finegold"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fineman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("finevest"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("finke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("finklea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fiore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("firearm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("firearms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firebaugh"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firebombed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firebombs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fired"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firefight"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("firefighter"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("firefighting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fireman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firemen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("firepower"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firestorm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fireworks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("firstier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fischl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fischler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fisler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fitzhenry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fitzwilliam"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fivecoat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fivefold"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flaharty"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flaherty"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flamemaster"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flavr"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fleer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flightsafety"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("flirtatious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("florea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flores"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("florine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flour"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("flours"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fluid"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fluidity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fluids"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fluitt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fluor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fogler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("foie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("foiles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("folkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("folliard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("folse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("foncier"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("fondiaria"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fondren"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fonte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("forbes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forcefulness"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("forde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forensic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forensics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forested"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forester"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("foresters"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("forestry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forests"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forex"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("forgue"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("formulaic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("forquer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fortieth"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fortuitous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fosler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("foulke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("foulkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("foward"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fowkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fowlkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("foxmeyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fractious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fractiousness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fragale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fraioli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("framework"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("francese"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("francke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("francoeur"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("franke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("frankincense"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frankl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("franze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("franzese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("franzone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frashier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fratzke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frazier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("freda"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frederic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frederick"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fredericks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fredericksburg"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fredette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("freia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fricke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("friedl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("friis"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fritze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fronde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frontier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("frontiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fruin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fruition"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fruity"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("frunze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("FSLIC"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fueled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuelled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("fuels"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fuer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fugue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fugues"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fukui"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fukuoka"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("fullilove"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("funches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("funderburke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("funke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fuoco"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("fuselier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fyffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("fyffes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gabbroic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gabehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gabele"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gaboriault"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gabriel"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gabriela"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gabriele"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gabrys"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gaffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gaffes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gaglione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gaia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("galatea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("galentine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("galesburg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galiena"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("galilean"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gallentine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("galyon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gambale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gambler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gamblers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gamesmanship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gamunde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gangl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ganske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gaona"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("garbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("garde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gardenia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gardenias"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gardiner"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("garoutte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("garske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gartzke"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("gastrointestinal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gatekeeper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gatekeepers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gateway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gateways"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gatewood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gatx"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gatzke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gauerke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gaulke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gawne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gdansk"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("geagea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("geerdes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gehres"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gehrke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("geissler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gelasia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gendarme"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("genealogy"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("generales"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("generically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("genetically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gengler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("genial"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("genitalia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("genius"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gensia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("genske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gensler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gentlest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("genuine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("genuinely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georges"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgetown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("georgiou"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gerace"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gerdeman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gerdes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gericke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gerke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("germe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gertler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("geschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gfeller"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ghanaian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ghanaians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giacco"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giacinta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giacobbe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giacomelli"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giacomini"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giacomo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giacone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giaimo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gialanella"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giambalvo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giambra"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giammarco"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giammarino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giampa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giampaolo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giampietro"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giancola"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gianelli"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gianfrancesco"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giangrande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gianino"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("giannattasio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannelli"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannetti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannetto"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gianni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannini"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannola"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giannotti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gianotti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giaquinto"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giardina"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giardini"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giardino"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giarratano"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giarrusso"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gierke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giesecke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giesler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giggly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giguere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gilberte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gilbertine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gilchrest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gilcrest"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gilkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gioia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giordani"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giordano"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giorgi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giorgia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovanelli"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovanetti"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovannetti"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovannini"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovannoni"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("giovenco"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("giovinazzo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giraffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("giraffes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("girdler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("girouard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gisler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gittler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("givebacks"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gjerde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glacier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glaciers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glazebrook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glenfed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glidewell"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("glimpse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gloucester"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("glyndebourne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goates"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gocke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goecke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goedde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goedecke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("goemon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("goering"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goerke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("goetze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("goewey"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gohlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("golde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("goldfinches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goleman"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("golembiewski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gomes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gondolier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gonorrhea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gonyer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gonzales"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goosefish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goosefoot"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("goracke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Gordievsky"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gottesman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gouin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("govea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("govpx"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grabbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("graceland"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grahams"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grande"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grapefruit"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grapefruits"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grapeshot"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grapevine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grapevines"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("graphically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grassia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gratuities"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gratuitous"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("gratuitously"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("graue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("graunke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("graveline"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("gravitationally"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("greasewood"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("greeniaus"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("greer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("greinke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("greunke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("griesa"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grinde"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("grismer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grobler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("groene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("groening"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grolier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grosvenor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("groveman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gruel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grueling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gruet"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("gruhlke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gruis"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("grulke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grunebaum"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grzelak"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("grzesiak"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("grzeskowiak"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("grzyb"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("grzybowski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("grzywacz"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("grzywinski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gschwind"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gsell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("gtech"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("guadarrama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gucciardo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guenette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("guerre"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("guglielmetti"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("guglielmi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("guglielmo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guiana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guidebook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guidebooks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guideline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guidelines"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guidepost"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guideposts"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guidone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("guidry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guillotte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guinier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guisewite"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gundry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gunfire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gurgling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gurion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gurtler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gusler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("gustave"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("guzzler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("gymnasia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("haacke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("habeas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hacienda"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hacke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hackl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hackler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hades"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hadler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("haering"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haeussler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hafeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hageman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hagemann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hagewood"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hague"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hahne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hajime"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("halcyon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("halcyone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haldeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hallbauer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("halteman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hamblen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hamler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hampe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hamtramck"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hanemann"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hanke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hankes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hanneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hannemann"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hanseatic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hapeman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("happe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("haque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harangue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harangued"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harangues"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("harare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("harclerode"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hardebeck"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hardeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hardwicke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harebrained"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("harewood"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harpe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harre"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("harte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hartl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("haruo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("haschke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hasler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hass"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hassler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hatheway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hatler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haueter"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hausler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("havelock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haveman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hawaii"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hawaiian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hawaiians"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hawke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hawkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hawkiness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haydn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("haynesworth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hbox"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hces"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hebrides"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hedgecock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hedgehog"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hedgehogs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hedgepath"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hegeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hehmeyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heideman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heidemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heidler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heigl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heikes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heileman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heindl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heinecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heineman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heinemann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heinicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("heinke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heinl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heinlen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("heintze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("heinze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heishman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("helbling"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("helionetics"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("helke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("helme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("helmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("helmke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hempfling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("henceforth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hendren"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hendrie"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("henke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("henkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("henneberger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("henneman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("henrie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("henrique"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hensler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("henze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("heppe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("heppler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("herculean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hercules"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hereby"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("herendeen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heretofore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("herewith"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hernandes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroines"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("heroism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("heroized"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("herre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hertzler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hessler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hestia"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("heterogeneity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hettler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hfdf"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hgh"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hialeah"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hibbler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hideaki"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hidebound"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hideout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hideouts"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hierarchy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hiers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hilde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hildegarde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hildegardes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hileman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hilemon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hilgeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hilliard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hilmes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hinchcliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hinchliffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hinde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hindes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hinduism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hineman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hintze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hinze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hippe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hippler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hirai"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hired"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hiroaki"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hirose"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hisao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hitzeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("HIV"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hjelm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hjort"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hobbyist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hobbyists"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hochstedler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hochstetler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hodde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hodgepodge"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hoefler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hoefling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hoehne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoene"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoeveler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoey"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hogue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("holcombe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("holdeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("holdren"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("holeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("holleman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holste"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("holte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("holyoak"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("holyoke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homebuilder"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homebuilders"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homebuilding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homebuyers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homecare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homeclub"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homecoming"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homegrown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homeland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homelands"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homelessness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homelike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homemade"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homemaker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homemakers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homemaking"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homeporting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homesick"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homesickness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homesley"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homespun"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homestake"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homestate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homestead"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homesteaded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homestretch"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hometown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homeward"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homewood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("homework"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("homeworkers"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("homogeneity"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("honea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("honse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoobler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoosier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hoosiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hopefuls"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hopelessness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hopewell"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hopke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hoppe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hoppes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("horatio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("horatius"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("horde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hordes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horehound"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hornblende"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseback"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseflesh"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horsehead"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("horsemanship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horsemen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseplay"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("horsepower"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("horseradish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseshoe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horseshoes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("horsetails"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hosea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hosler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hosseini"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hostetler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hostutler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hotelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hoteliers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hottelet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hotwired"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hotze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hour"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hourglass"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hours"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houseboat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("housebroken"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("housecleaning"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("household"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("householder"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("householders"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("households"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("housekeeper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("housekeepers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("housekeeping"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houseknecht"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houseware"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("housewares"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("housewife"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("housewives"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("housework"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houseworth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("housewright"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("houy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hovde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("howse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("howze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hrawi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hrdlicka"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hrncir"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hrubik"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hsiao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hsieh"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("huachuca"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("huallaga"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("huan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huaneng"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("huang"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("huard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hucke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hudler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("huetta"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("huette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huey"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("huffstetler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("huffstutler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hufstedler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hufstetler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huggler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hui"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huibregtse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huish"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hulme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hulse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("humblest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("humfry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huml"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("humphries"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hunches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hunke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("hunte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huot"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hurdler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hurdling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("huseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hustler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hustlers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hustling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hyades"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hydroelectric"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hydropower"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("hygeia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hyperbole"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hyperborean"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("hypothetically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("hysterically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("hyun"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iafrate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iain"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("iannaccone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("iannacone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iannone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("iavarone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ibn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iceberg"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("icebergs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("icebox"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("icebreaker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("icebreakers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iceland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("icelandair"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("icelandic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iceskating"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ickes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("idalia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("idealistic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("idealized"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ideas"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ideologist"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ideology"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ideonomy"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("idiotically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("idler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("idling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ierardi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iezzi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iglesia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ignatius"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ihde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ihrke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iiams"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iida"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ijames"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ikea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ileana"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iliescu"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ilse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imageries"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imagery"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imbroglio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("immense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("immensely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("immunetech"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("impartiality"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("imperiale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("impetuous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("impoverish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("impoverished"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("impoverishes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("impoverishment"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("impulse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("imrie"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("inalienable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("incense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("incestuous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("inches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("incipient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inconspicuous"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("incoordination"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("incorvaia"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("indianians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("indifferent"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("indosuez"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("indulged"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("industriale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inequity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ines"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("inexperience"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("inexperienced"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("infectious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ingenious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ingeniously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inglish"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ingratiate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ingratiating"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("initiate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("initiated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("initiates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("initiating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("initiation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("initiator"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("initiators"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("inmobiliaria"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inouye"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inquired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inquires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inquiries"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("inquiring"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inscore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("inspired"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("institucional"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intaglio"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("intelligentsia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("intense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intensely"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("intercollegiate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interdictes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("interest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interested"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("interesting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("interests"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("intermingling"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("internationale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("intrigue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("intrigued"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("intrigues"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("intuit"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("intuition"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("intuitive"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("intuitively"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("invaluable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iole"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ione"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iorio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iou"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("iovine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ironically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ironton"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("iroquois"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("isadore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("isaiah"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("isautier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("iseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("isms"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("isoelectronic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("isosceles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("israel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("italian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("italianate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("italians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("itll"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ixion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("izquierdo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("izvestia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jacinthe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jacobean"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jacque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jacques"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jacquie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaenicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jahnke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaimes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jakeway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jameson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jamestown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jamesway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janeway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("janicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("janke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jaques"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jared"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jayme"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jaymes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jeers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jefferies"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jeopardizes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jerboas"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jerde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jere"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jeroboam"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jerrome"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jeschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jesmer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jesuit"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jesuits"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jewkes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jiang"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jiangsu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jiawen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jingoism"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("jingoistic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joachim"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joachims"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("joanna"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jocelin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joceline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jocelyn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jocelyne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jocylan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joedicke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joey"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("joffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("joie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jolicoeur"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jolliffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("jorde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jose"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("joycelyn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jr"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("jua"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("judishe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juedes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juenemann"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("juhnke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("julietta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("jurgensmeyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("juul"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kadrmas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kahane"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kahle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kahre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kalliel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kalthoff"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kamakau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kamikaze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kamler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kampe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("Kampuchea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kanade"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kaniewski"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kanouse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kantian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kaohsiung"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kapler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kappes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kappler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("karaoke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("karate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kardashian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kartes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kaseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kasler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kasprzak"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kasprzyk"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kasriel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kassler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kastenmeier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kastl"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kataoka"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("katharine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("katia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kawai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kawate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kazuo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keay"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keebler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("keeffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kehne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kehres"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keiichi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keisling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keister"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("keisuke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keleman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kelemen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kempe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kempke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kenealy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kennebeck"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kennemore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kensler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("keplinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("keppler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kerien"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Kerouac"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kerpedjiev"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kesler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kesling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kessler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kganakga"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kgori"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Khaled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kibbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kidde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kiehne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kiev"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kigale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kightlinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("killian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("killilea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kimbler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kimbriel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kimler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kindler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kingry"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kinsler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kinzlmaier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kiplinger"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kippes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kirouac"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kisling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kissler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kjar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kjos"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("klabunde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kleer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kleindienst"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("klenke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kleppe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kliethermes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("klingler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("klinke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("klitzke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("klocke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kmart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kmetz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kmiec"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kmiecik"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("knapke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kneer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("knievel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("knifelike"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("knobbe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("knoedler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("knowledgeware"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("knowles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Knute"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koala"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kociemba"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koegler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koehne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koepke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koeppe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koestler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koetje"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kofler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kogler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kohne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kohnke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koichi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kokate"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kolbe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("kolodziejski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kooy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kooyman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kopke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koppe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("koppes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("korea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("koreagate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("korean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koreans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koreas"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("korte"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("korzeniewski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kosanke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kostrzewski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("koteles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kotler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kottler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kouri"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kowalke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krabbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kracke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kraeutler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("krajina"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krampe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kratzke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krauer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kreher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kreidler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kreisher"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krenke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kressler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krienke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kriete"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("krinke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kristoffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kroening"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kroenke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("krone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kruckeberg"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kruschke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ksiazek"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kuala"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kuchler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kudrna"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kuechler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuehne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kugler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuhne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuhnke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kumagai"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kunde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kuntze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("kunze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kuo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kusler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kuzniar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kvale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kvam"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kvasnicka"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("kvetch"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kveton"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("kvistad"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("kvitsinsky"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("kwh"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("labbe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("labine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("labonte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laboratories"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laboratory"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laborde"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("labossiere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("labouisse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("labrecque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("labrie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lacaze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lacefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lacewell"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lacoursiere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lacquer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laduke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laferriere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laffitte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lafitte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lafler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laforte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lafreniere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lagace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lagrone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lahaie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laimbeer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lajoie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakefront"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakeland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakeshore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakeview"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lakewood"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lalone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamaist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lambe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lambiase"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lamere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lamonte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lamotte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lampe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lampl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lancelet"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lande"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("landes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("landfried"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lanehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lanese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("langelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("langone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lanier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lanphier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lansdowne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laos"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laotian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lapine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lapointe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laporte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lappe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laprade"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lapse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laraia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lareina"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("larine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lariviere"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("larke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("larocque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("laroque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("larose"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("larrea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("larroquette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laryngeal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lastrapes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("latticework"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("launches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laureate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laureates"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("laurentiis"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laverdiere"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("laverdure"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lavere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lavergne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lavine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lavinia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lavoie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lawrenceburg"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lawshe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lawyer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lawyerly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lawyers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lazare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lcs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ldbrinkman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leaches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("league"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leaguer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leaguers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("leagues"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leah"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leander"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leandro"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leapfrogged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leaseback"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leasebacks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leasehold"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leaseway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lebegue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leboeuf"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lebouef"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leccese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lecompte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lecomte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lecrone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leeches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leeuwen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leffler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("legare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("legrande"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lehne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lehrke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leibfried"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leibler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leicester"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("leitzke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lelia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lembcke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lembke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lemcke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lemieux"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lemire"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lempke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lendl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lenient"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lenke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lentine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leonelle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lepere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lepine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lepore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lequire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lereah"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lesane"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lesesne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("letarte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("letitia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lettiere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("leveque"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("leveraging"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("leverone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("levien"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("levitte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lezotte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lhommedieu"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("liaison"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("liaisons"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("liang"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liasson"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("liberalization"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("liberatore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("licciardi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("licea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("license"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("licentious"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lichte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liebler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lieurance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Lieut"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lieutenant"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lieutenants"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeblood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeboat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeboats"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeco"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeguard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifelike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifeline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifelines"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifelong"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lifesaver"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lifesavers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lifesaving"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifespan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifestyle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifestyles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifetime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lifetimes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("liffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("likelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("likeliest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("likelihood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("likewise"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lilienthal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("limehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("limelight"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("limestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("limestones"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("linde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lindeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lineage"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("lineages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lineal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("linear"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("linearly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lineback"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("linebacker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("linebackers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lineberger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lineman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linemen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lineweaver"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("linguistically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("linke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("linnea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("linnemann"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("linoleum"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("linse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lipke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lippe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liqueur"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liqueurs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("litalien"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("litigious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("littlest"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("liu"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("livelier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("liveliest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("livelihood"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("liveliness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("liveried"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("livestock"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("livonia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lizotte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("llorens"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("loaiza"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lobbyist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lobbyists"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("locke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lockyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lodestar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lodestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lodgepole"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loeffler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loella"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loess"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loew"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loewen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("loewenstein"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("loewenthal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("logarithms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("logically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("logistically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("logiudice"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("logue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lohnes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lohse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("loiacano"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("loiacono"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lois"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loise"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("loneliness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lonetree"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("longenecker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("longshoremen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loosestrife"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loosestrifes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lopeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lorean"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lotte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lottes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lotze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("louanna"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("louart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("louisette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("louque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lourdes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("louviere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loveday"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lovegrove"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lovejoy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loveland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("loveridge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lovewell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lowekamp"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lp"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lpn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ls"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lsd"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ltd"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lubke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lucchese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luciani"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lucianna"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lucien"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lucke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luckiest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ludeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ludemann"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("luebbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("luebke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lueck"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("luecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luedecke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luella"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luera"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("luevano"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lui"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luigi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luisa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lukehart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lukewarm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luncheonette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lunches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lunde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luoma"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luong"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("luongo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("luque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luquette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lutze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lutzke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("luu"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lynde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lyon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lyondell"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lyonnais"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lyonnaise"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("lyons"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("lyphomed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("lysne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mabry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("macaques"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maccabean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("macdiarmid"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("machete"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("machetes"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("machiavellian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("machinea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maciag"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maciejewski"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("macke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mackiewicz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("macmahon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("macqueen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("macrame"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("macwilliams"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("madl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("madlen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("madore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maeda"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maekawa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maenza"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maestri"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maez"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maglione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("magnolia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("magnolias"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("magnone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("magouirk"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("maher"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mahnke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mainichi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maio"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maiolo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maiorana"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maiorano"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maiorino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("majure"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("makegoods"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("makeshift"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malave"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("malinde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maline"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("malkiel"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("malleability"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("malleable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mandl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manfred"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mangiaracina"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mangine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mangling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mangone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mangope"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("manke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mannerisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("manrique"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("manske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("manthe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mantione"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("manzanares"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("manzione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maoris"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mapplethorpe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("maraline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("marcelline"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marchese"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("marchione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marcial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marciante"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marcone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marcotte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("margeotes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("margiotta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mariel"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("marielitos"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("marijuana"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marineland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marje"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("markedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marotte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marquee"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marquees"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marques"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("marquette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marriages"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marrone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marschke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("marthe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("martinique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("martire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("martone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("marui"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masaaki"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("masai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("masao"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("maschke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("masciarelli"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mascioli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("masefield"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maslen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("massacring"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("massicotte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("massingale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mastandrea"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mastrogiovanni"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mastroianni"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("matarese"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("materiel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mathai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mathea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mathieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mathilde"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("matrilineal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("matsui"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("matsuo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("matsuoka"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("matsuura"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("matte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mattes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("matthea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("matthes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("matzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maurine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mausoleum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mawr"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maxion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("maxzide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("maybe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mazowiecki"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mazzei"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mazzone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mbank"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcalinden"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcauliffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcbrien"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mccaffery"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mccague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mccahan"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mccarthyism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mccaughan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mccluer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mccuin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcdiarmid"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcgeough"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcgoey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mchargue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mckeague"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcmillian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mcmurtrie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcneer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcqueary"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcqueen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcqueeney"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mctague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mcteer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mctigue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcwilliam"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mcwilliams"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meagher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meander"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meandered"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("meandering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meanders"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mechanically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mechanisms"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meckes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("medically"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("mediterranean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("medlen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meetze"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("megacarriers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("megace"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("megalomaniacal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meidl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meierfeld"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meincke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meindl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("meinecke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meinke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meiosis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("melamed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("meloche"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("melone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("memorabilia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("menapace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("menasion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mende"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Mengele"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("menke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("menkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("menstruation"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mente"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("menze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mercedes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mercure"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("meridionale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("merion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("merle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("meschke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("meserole"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mesler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mesozoic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("messagepad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("messler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("messrs"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("metabolisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("metcalfe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("methodisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("metier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mettler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("metze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mfume"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("micale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("micciche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("michener"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("michl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("micke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("microcosm"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("micrografx"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("microorganisms"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("microscopically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("midyette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("miert"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("migliore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mignone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mijares"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mildrid"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("milestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("milestones"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("milieu"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("milke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("milne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("milnes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("minamide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mincemeat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("minebea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minesweeper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minesweepers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mineworkers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mingling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("miniard"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miniaturized"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minjares"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("minke"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("minneapolis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minoan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minogue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("minteer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minuet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("minuteman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mireles"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("misbehavior"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miscarriages"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mischarged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mischke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mischler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("miscreant"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("miscreants"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("miscreations"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("misfire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("misled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mismatched"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("missildine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("missler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mitschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mitsui"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mittler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("mixte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("miyake"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mkhatshwa"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moab"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moammar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moates"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mobiliare"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("modestine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moening"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("moerbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("moerke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moerman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mohamed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mohammed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mojave"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("molehill"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("molelike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("molesworth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("moncure"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("monde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("monisms"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("monje"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("monologue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("monologues"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("mononuclear"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("monotheism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("monsieur"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("monsieurs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montagnier"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("montefiore"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("monteleone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montgomery"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montiel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montien"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montieth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("montone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moorehead"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moorehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moorestown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moosehead"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("moppes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morace"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morehead"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moreland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moreman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mores"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("morever"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("morgue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morones"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morriss"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("morrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mortgagepower"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("morze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mosaic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mosaical"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mosaics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moseley"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("moseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mosier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mosler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mothershed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("motl"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("motorcyclist"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("motorcyclists"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("motte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mousehole"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mousetrap"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mozambique"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mozartean"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mpeg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mpg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mph"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mr"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mrs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("msgr"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mssrs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mtel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("muecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muehlebach"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("muffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mufflers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mugabe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("muhamed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("muhammed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mui"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mukai"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mulches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mulqueen"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("multiemployer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mulvehill"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mungia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("munguia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("muraoka"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("muratore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("murguia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("muriel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("murrelet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("murrieta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("muscling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("museum"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("museums"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("musically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("mustaches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("mustachioed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("myhre"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("myocardial"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("myocardium"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("myopia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("myopic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("myosin"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("myotrophin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("mystique"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("NAACP"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nacional"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nacke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nacogdoches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nadal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nadler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nagai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nagao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("naim"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("naish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("naive"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("naively"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("naivete"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nakai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nakao"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nakasone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("naked"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nameplate"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nameplates"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("namesake"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nantes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("naoma"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("naomi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("napea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nardone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("narvaez"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nasional"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nasr"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("natale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("natalia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nationale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nationales"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("natzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nausea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nauseated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nauseating"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nauta"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("navellier"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("nazionale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neanderthal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neanderthals"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("neapolitan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nedlloyd"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("needler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("neer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("negotiate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("negotiates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiations"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiator"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("negotiators"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("neidl"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neidlinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neisler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("neitzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nemean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neoax"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neorx"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nepl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nessler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nestea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nestler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("neuendorffer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("neuroscience"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("newcombe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("newgateway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("newtowne"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ngema"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("niagara"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("niaid"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("niall"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nibbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("niches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("niclaneshia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nicolai"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nicoline"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nicosia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nienhuis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nieves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("NIH"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("niihau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ninefold"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nineteen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nineteenth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nineties"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ninety"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ninneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("niquette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("nitrosamines"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nitschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("njt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noah"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nobbe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nobuo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nodine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("noffke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nogales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nogueira"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noire"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nolde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nolte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noncorporate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nondefense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noninterest"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nonlinear"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nonnuclear"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nonreligious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nonsense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nordine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nordling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("noriega"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("noriegas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("norsemen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("norte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("norwegian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("norwegians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nosebleed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nosedive"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nosedived"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noseworthy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nostalgia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("notebook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("notebooks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noteholders"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("notestine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noteware"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("noteworthy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("notte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nov"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noxema"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("noxious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nuclear"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("nucleation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nuclei"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nucleic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nucleus"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("numed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("numerically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nunemaker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("nunsense"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nurre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nusbaum"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nutrient"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nutrients"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nutritious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nvhomes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("nvryan"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("nyers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oad"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oahu"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oases"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oasis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obermaier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oblique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obliquely"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oblivion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obnoxious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oboist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("obrien"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("obscenely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("observed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ocain"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("occupiers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oceanic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oct"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oddler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("odele"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("odp"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("odysseus"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("oehlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("oehme"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oeien"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("oelke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oeuvre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ofc"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("offense"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("officeholder"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("officeholders"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("officemax"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oglethorpe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ognibene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oguin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ohare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ohlmeyer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("oie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oishi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ok"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("okabe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("okane"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("okayed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("okeeffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oken"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("okoniewski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("olague"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("olde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("olea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oleander"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oleaster"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oligarchs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("olinde"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("olivares"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("omelet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("omelets"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oncale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oncogenes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("onecomm"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("oneself"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("onetime"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("oooh"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ooohs"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ooten"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("opaque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("opera"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("operas"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ophelia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oplinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("optically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orangeburg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("organically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("organisms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orgasms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oriental"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("orientals"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("orientation"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oriented"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oriordan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orleans"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("orme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ormes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ormonde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("orourke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orpheum"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("orpheus"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("orthodontia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("osake"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("oshea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("osmer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("osred"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ostentatious"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("ostentatiously"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("osteoarthritis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ostia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ostling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ostriches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("otte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ouimet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ouimette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("our"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ourada"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ours"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ourself"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("outler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("outstretched"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("overambitious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Overbye"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("overcharged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("overmatched"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overreaches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("overreact"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("overreacted"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("overreacting"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("overreaction"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("oviedo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pacemaker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pacemakers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pacesetter"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paceway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pagemaker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("painewebber"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paiute"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("palauans"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("paleozoic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("palese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pallone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("palme"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("palmieri"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("palmstierna"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("palomares"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("panacea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pancreas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pancreatic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pannone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("panthea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pantheistic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paolella"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paoletti"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paolillo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paolini"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paolino"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paolucci"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paonessa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("papale"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("papandrea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("papier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("papke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("paque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("paquette"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("paradoxically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paranoia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paranoiac"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("paraphernalia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paratore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("parde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("paredes"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("parimutuel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("parke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("parkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parliament"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("parliamentary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parliaments"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("parmele"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("paroxysm"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("partecipazioni"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("partiality"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("parziale"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("paschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pasquale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("passageway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("passaic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pastiches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patnaude"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patrie"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("patrilineal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("patrone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("patzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pautler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pavese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacefulness"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacekeeper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacekeepers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacekeeping"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacemaker"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacemakers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peacemaking"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peacetime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peaches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pearle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pecore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("peculiar"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("peculiarly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peddler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peddlers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pedone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peebler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("peer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peerless"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("peers"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("peinado"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pelaez"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pelagia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pele"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pelletier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("penelope"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pennsylvania"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("penthea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peopled"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pepe"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("pepenadores"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peppler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("peragine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("peraino"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("peres"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pergande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("perle"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("permeability"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("permeate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("permeated"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("permeates"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("perniciaro"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("perricone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perrine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("perseus"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("persuadable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("persuade"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("persuaded"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("persuades"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("persuading"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("persuasion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("persuasions"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("persuasive"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("persuasively"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("persuasiveness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pescatore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("peschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("petrea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("petroleum"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("petrone"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("petrovietnam"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("petteway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pettine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pevehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pfiester"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ph"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pharaonic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("pharisaism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phaseout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phebe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("philistia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phillippe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("phineas"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("phlcorp"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phoebe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phonemate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("phonetically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("photoelectric"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("photovoltaic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("photovoltaics"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("phuong"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("physique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("piccone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pichler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pickler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pickren"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("picotte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("picower"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("picturetel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("piecemeal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("piecework"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("piedboeuf"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pierette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pierrelouis"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("piers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pieties"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pietro"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pietruski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pietrzak"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pietrzyk"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("piette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("piety"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pignone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pigue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pilotte"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pingitore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pipefishes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pipeline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pipelines"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pipetec"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pique"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("piqued"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("piquette"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pirkl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pirrone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pisces"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pischke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pisciotta"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pitchblende"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pitiable"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("pituitary"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("placeway"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("placke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("plagiarism"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plague"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plagued"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plagues"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plaia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plaisted"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plante"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plaque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plaques"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plateauing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("platelets"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("platelike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("platinum"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("platte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("plebeians"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pleiad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pleiads"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("plenmeer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plouffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("plourde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pneumonia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poage"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pocius"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poem"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poems"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poeschl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("poetic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("poetry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poets"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("poggioli"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pogue"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("poinsettia"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("poinsettias"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pointe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poitier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pokeweed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("polecat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("polecats"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poleward"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("policeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("policemen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("politte"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("polytheism"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("polytheistic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("polyurethane"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pomrenze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ponce"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ponte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pontiac"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pontiacs"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pontikes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pontious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pooches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("popejoy"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("popieluszko"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("popolare"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("poppe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("poppea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("poquette"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("portales"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("porte"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("possiblity"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("postindustrial"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pottebaum"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pouches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("poudrier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pourciau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("powercise"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("powerfully"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("powerpc"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("powerpcs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("powertrain"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ppm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("practically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("prague"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("praiseworthy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pratte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("prayer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("prayers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prechtl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preciado"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("premier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("premiers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prentnieks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("preponderance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prescience"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prescient"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("preserved"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("presler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("presse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pressler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("prestigiacomo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prestigious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pretense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("pretentious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prevatte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pridemore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("priest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("priester"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("priestly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prieta"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prieto"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primebank"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primeco"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primenews"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primestar"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("primetime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("princeton"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("principally"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("principe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prindl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("priore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pritzl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("privileges"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prizewinner"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prizewinners"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prizewinning"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prizm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("procreate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("procreates"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("procreation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prodigious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prodigiously"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("proia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("proj"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prolifically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("prolinea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prologue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("promiscuous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("propitious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prosaic"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("proskauer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("proske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("protean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("protease"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("protege"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("protozoan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("protozoans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("provincetown"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("provine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("prowse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prudente"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("prudentialbache"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pruitt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("prunedale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("prurient"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("pryor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("przybyl"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("przybyla"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("przybylski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("przybysz"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("przywara"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pseudoscience"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("pseudoscientific"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("psyche"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("psyches"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("psychoanalysis"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("psychoanalyst"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("psychoanalytic"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("psychologically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ptolemaic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pucciarelli"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("puente"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("pugliese"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pulse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("punches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("purebreds"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("puritanisms"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("puzzler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("pylant"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("qiao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("qiaotou"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("qmax"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("quadrupling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quagmire"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quarles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quarre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quassia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quattrone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quealy"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("queasiness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queasy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queena"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queenan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queener"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queenfish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queenie"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queens"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("queensberry"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queensland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queensway"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("queerer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("queues"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quiett"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quiles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("quillian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quilmes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quirion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("quirke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("quixote"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("racamier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("racehorse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("racetrack"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("racetracks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("raceway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("racioppi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rackliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("radcliffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("radde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rademaker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("radiance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("radically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("radioed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("radler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rafael"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("raffaele"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("raffaelli"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("raffety"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rafuse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ragone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ragonese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rai"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("raia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rainier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rakestraw"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rambler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ramblers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rambunctious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ramires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ranches"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ranieri"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ranke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rapeseed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("raphael"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rappe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("raschke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rasia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ratcliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rateliff"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ratepayer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ratepayers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rathje"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rathke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ratier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ratliffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ratte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rauls"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rawles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rb"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reaches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reacquire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reacquired"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("react"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reacted"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reacting"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reaction"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reactivate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reactivated"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reactivating"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reactive"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reactivity"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reactor"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reactors"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reacts"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("readjust"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("readjusted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("readjusting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("readjustment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("readjustments"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("readmitted"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reaffiliation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reaffirm"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reaffirmation"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reaffirmed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reaffirming"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reaffirms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reagents"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappear"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reappearance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappeared"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappears"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reapply"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappoint"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reappointed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reappointment"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reapportionment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reappraisal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reappraise"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rearm"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rearmament"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rearrange"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rearranged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rearranging"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rearrested"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassemble"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassembled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassert"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reasserted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reasserting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassertion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reasserts"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassess"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassessed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassessing"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassessment"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassign"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassigned"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassigning"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassignment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassignments"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassume"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassumed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassurance"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reassurances"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassure"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassured"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reassures"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reassuring"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reassuringly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reatta"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reawakened"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reawakening"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rebellious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("recharged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recipe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recipes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recipient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recipients"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recompense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recreate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recreated"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("recreates"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recreating"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recreation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("recreational"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("recycling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("redactes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rediscovery"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("redlinger"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reelected"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reelection"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reemergence"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reemployment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reenacted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reenactment"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reenactments"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reenacts"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reengineering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reenter"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reentering"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reentry"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reestablish"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reestablishing"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reevaluate"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reevaluating"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reevaluation"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reexamination"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reexamine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reexamined"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reexamining"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reexport"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reexports"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refenes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reflagged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refuel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refueled"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("refueling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refusenik"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("refuseniks"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("regalia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rehired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reichart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reichl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reichling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reignite"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reignited"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reigniting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reimagine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reimburse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reimbursed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reimburses"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reimbursing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reimpose"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reimposing"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reimposition"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reina"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reincarnated"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reincarnation"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reincke"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reincorporate"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reincorporating"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reincorporation"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reindeer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reindl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reinecke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinforce"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinforced"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinforces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinforcing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reinke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinspection"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinstate"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinstated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinstating"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinstitute"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reinstituted"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reinstituting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinsurance"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinsure"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinsured"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinsurer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinsurers"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reintegrated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinterpret"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reinterpretation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reinterpreted"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reinterpreting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reintroduce"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reintroduced"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reintroduces"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reintroducing"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reintroduction"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinvent"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinvented"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinventing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinvest"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinvested"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinvesting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reinvestment"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reinvests"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reinvigorate"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reinvigorated"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reinvigorating"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reinvigoration"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reischauer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reissue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reissued"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reissuing"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reister"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reitano"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reiterate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reiterated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reiterates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reiterating"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("reiteration"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("relapse"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("religione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("religious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("religiously"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("relying"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reminisces"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("remlinger"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rempe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("renate"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rende"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rene"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("renegotiate"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("renegotiated"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("renegotiating"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("renegotiation"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("renegotiations"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("renfred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("renschler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rensselaer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reorient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("repetitious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reponse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("repulse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("require"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("required"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("requires"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("requiring"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("reschke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("researched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("resendes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reserved"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("resiliency"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resilient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("resourcefulness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("response"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("resseguie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ressler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("restaino"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("retaliatory"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("retemeyer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("retroactive"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("retroactively"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("retroactivity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reum"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("reunification"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reunified"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reunify"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reunion"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reunions"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reunite"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reunited"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reuniting"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("reusable"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reuse"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("revaluations"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reveles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("reveres"));
        $this->assertEquals(8, $this->TextStatistics->syllableCount("revolucionario"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rewire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rewired"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rewiring"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("reyes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhea"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("rhetorically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhinehardt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhinehart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhineland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhineman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhinesmith"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhinestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhinestones"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhodanthe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rhythmically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rhythms"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rials"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ricciardelli"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ricciardi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ricciuti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("richelieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ricke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ricocheted"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("ricostruzione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rideout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ridgecrest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ridgefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ridgeway"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("riecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riedl"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("riedlinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rietveld"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rietz"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("riffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rigler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rigueur"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rijn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rinehardt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rinehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rinehimer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ringler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ringuette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rinke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rinse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("riordan"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rioux"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ripke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rippe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rissler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("riviera"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("riviere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rivieres"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roaches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roanoke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roarke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("robare"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("robbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rocke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rocque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rodarte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roderick"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rodeway"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rodine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rodrigue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roebke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roedl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roelke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roepke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roesler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roethler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roever"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rogue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rogues"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rohde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rohweder"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roleplaying"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rolfe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rolfes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("romesburg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("romine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("roque"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roquemore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rorke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseboom"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roseboro"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("roseborough"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosebrock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosebrook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosebrough"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosebush"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosecrans"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosekrans"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roselawn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rosemarie"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rosemary"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosemead"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rosemeyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosemond"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosemont"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosenau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosevear"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosewicz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rosewood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roshier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rosine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ROTC"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rothmeier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rottler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rouillard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("roukema"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rourke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rouyn"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("rovaniemi"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rowles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("rowse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rpm"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rueda"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ruella"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ruhnke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruined"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ruining"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ruinous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruins"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruis"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruiz"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("rulebook"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rulemaking"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("runde"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("runte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ruocco"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ruoff"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ruotolo"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ruppe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rustlers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rwanda"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rwandan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rwandans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rwandese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ryobi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ryohei"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ryon"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ryuzo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rzasa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("rzepka"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sabatine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("saccone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sachse"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sacrilegious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safecard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safeco"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safeguard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("safeguarding"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safeguards"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("safekeeping"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safety"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safeway"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("safier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sagebrush"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sagraves"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saif"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("saitama"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sakai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sakau"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sakigake"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sakurai"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salesman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("salesmanship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salesmen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("salespeople"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("salesperson"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("salisbury"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("salome"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("salomone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("salvadore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("salvatore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("salzhauer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("samuela"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("samuels"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("samuelson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sanches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sandbagged"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sandwiches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sansui"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("santacroce"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("santerre"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("santiago"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("santone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("santore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sanzone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sapiens"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sapone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sapphire"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sarcastically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sarine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sarles"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sassone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("satiny"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("satire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("satires"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("satisfactorily"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("satisfactory"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sattler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saucepan"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saute"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sauter"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("savarese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("savior"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("saviors"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("savoia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("savoie"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("savr"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sawyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sawyers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sayed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sbf"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scaglione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scalese"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scapegoat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scapegoating"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scapegoats"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scarpone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schadler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schaedler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schaefers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("scharfe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schaufler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schedler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scheidler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scheufler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scheunemann"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("schiavone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schickler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schickling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schielke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schildknecht"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schilke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schimke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schinke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schisler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schisms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schloesser"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schmidl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schmutzler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schoene"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schoening"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("scholtes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("scholze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schoneman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schoppe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schouten"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schreder"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schreyer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schroedl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schubring"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schuelke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schuerman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schuermann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schuessler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schuette"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schuetze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schulte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schultes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schultze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schulze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schuneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schussler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schutte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schuttler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwalbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwanke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwantes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwarze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwebke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schweder"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schweer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schweers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schwegler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("schwendeman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schwenke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schweppe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("schweppes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("schwoerer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sciacca"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scialdone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sciandra"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scianna"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sciara"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sciarrino"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sciclone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("science"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sciences"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scientific"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("scientifically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scientifics"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scientist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scientists"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("scientology"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scintilore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("scipione"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scohier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scoreboard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scorecard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scorekeepers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scour"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scoured"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("scouring"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scours"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("screeches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scribblers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scrimgeour"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("scrivener"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sdn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("se"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seabed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("searle"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seattle"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("sebastiana"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sebastiane"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("sebastiani"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sechrest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sechrist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("secrest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("secrist"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("securites"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seditious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sedore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("seer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("seers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("segraves"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("segrest"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("segue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seidl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seifried"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seigler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Seiichi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sekisui"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("selbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seles"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("selke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sellier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("semele"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("semireligious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("semmler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("semones"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("senatore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("senior"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("seniority"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seniornet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seniors"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sense"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("senseless"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("senske"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("seoul"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("separate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sequeira"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sequences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sequoia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sequoias"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("serafine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("seraphine"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("serenely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sergius"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("serpe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("serratore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("serviceman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("servicemaster"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("servicemen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sesame"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("Sese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sessler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("settlers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("seve"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("seventieth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("several"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("severally"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sevier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("seyfried"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sh"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shakedown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shakedowns"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shakeout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shakespeare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shampooed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sharecroppers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shareholder"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shareholders"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shareholding"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shareholdings"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shareware"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sharpe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sheer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sheffler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("shenandoah"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sheneman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shidler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shiffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shiina"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("shiraishi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shiremanstown"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shisler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shissler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shiu"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shoichi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("shoichiro"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shooed"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shoppe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shoppes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shorebird"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shoreham"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shoreward"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shoshone"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("shouldnt"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shoveling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shreffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shrikelike"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shryock"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("shuddered"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shuey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("shui"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sichuan"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sicilia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sicotte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sidetracked"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sidler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("siegecraft"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sienko"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sierra"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sierracin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sierras"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("siers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("siewiorek"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sigl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sigler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("signore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("simione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("simpler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("singaporean"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("singaporeans"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("singler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("singling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sinuous"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("siobhan"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sioux"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("siracuse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sirrine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sisemore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sistare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sitler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sittler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sitze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sixtieth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizeler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizelove"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizemore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sizzler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("skateboard"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("skateboarding"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("skibbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("skier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("skrzypek"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sledgehammer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("slouches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("smokejumper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("smokejumpers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("smokescreen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("smokestack"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("smokestacks"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("smtih"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("snakebites"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("snakelike"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sneer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sneers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soares"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sobieski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sociable"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("societa"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("societal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("societe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("societies"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("society"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sociopath"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("socrates"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sofaer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("solares"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soldier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soldiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soledad"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("solesbee"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("solimine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soloist"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soloists"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("soltes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("somebody"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("someday"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("somehow"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("something"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("somethings"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sometime"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sometimes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("somewhat"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("somewhere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sonia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sooy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sophomore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sophomores"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sosuke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soulliere"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sour"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sourcebook"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("soured"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("souring"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sourly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sours"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("Sousuke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sovereign"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sovereigns"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sovereignty"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("sovietologists"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("soviets"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sowle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sowles"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaceballs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spacebands"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spacecraft"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spacelink"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spacenet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spacesuit"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spadework"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("spagnuolo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spangler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaniard"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaniards"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spanier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spaniol"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sparkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spasms"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("speciale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("specialities"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("speciality"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("specifically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("speeches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("speer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spengler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("speziale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spieth"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("spilde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spinale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spindler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("spiritualism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spitale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spittler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spokeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spokesman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spokesmen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spokespeople"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spokesperson"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sponsler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("spontaneity"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("spoonemore"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sporadically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sporophyte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sporophytes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("spracklen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sprague"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("spruiell"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeak"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeaked"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeaker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeakers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeaking"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeaks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeaky"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squealing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeamish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("squeamishness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeegee"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeeze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squeezed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squeezing"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("squiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("squires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sr"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stablest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("staebler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("staehle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stagecoach"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stagecraft"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stagehands"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stahnke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stai"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stakeholder"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stakeholders"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stakeout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stakeouts"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stalemate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stalemated"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stangl"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stangler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stanke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stanzione"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stapler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("staplers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stapling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("starace"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("starke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("starkes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("starpointe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statecraft"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statehood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stateroom"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statesman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("statesmanship"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statesmen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stateswest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("statewide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stechschulte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steffes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("steffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stefl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stegeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stegemann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stegemeier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("steidl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steinke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stemmler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stepien"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steppe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("steppes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stettler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("steuart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stickler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stiegemeier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stiffler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stineman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stiteler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stobbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stocke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stoeltze"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stoever"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoia"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoic"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stoicism"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoics"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stokke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stolpe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stolte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stolze"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneback"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneberg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stoneberger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stoneburner"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stonecipher"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stonecutters"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneham"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonehenge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonehill"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stonehocker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneking"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneridge"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonerock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonestreet"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonewall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stonewalled"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stonewalling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stoneware"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("storagetek"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("storefront"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("storefronts"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("storehouse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("storekeepers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("storeroom"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stormes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stracke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stragglers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("strande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("strangling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("strategically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("strehle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("striar"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stribling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("stricklen"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("strieter"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("strikebreakers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("strikeout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("strikeouts"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("strubbe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("strzelecki"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stubbe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stucke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("stumpe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("stutesman"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("stylistically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("styron"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suarez"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suasion"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("suave"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suazo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("submerged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("subnotebook"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("subservience"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("subservient"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("substantiate"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("substantiated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("substantiates"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("substantiation"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("subterranean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("subtler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("subtly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sudafed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sudler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suey"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suez"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("suhre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sui"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("suicidal"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suicide"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suicides"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sumptuous"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sunde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sundial"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("sunobe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("supercharged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("superfamily"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("superfluidity"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("superfluous"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("superstitious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("superx"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("suppes"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("supremely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("supremes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("surace"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("surreptitious"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("surreptitiously"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suspense"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suspenseful"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("sutcliffe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("suttmeier"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("suu"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("svelte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("swanke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("sweers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("swindler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("swinehart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("swingler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("swoveland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("synagogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("synagogues"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("synthetically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("sypniewski"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("systematically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("systemically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("taaffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tabares"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tacke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tadeusz"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("taffe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("taflinger"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tagliaferri"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tague"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("taira"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("takao"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("takecare"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("takeout"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("takeuchi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tamales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tanabe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tangeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tangiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tania"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tanke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tannehill"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("taormina"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tappe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tarleton"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("tartaglione"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tarte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tassone"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tatiana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tattler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tattooed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tavares"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("tavoulareas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tb"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tbilisi"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tcas"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teaches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("teague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("teate"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tebbe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tebuthiuron"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("technique"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("techniques"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("teer"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tele"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("teleconference"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("teleconferencing"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("telemecanique"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("telephoniques"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("telesciences"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("temperament"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("temperamental"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("temperamentally"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("temperaments"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("temperate"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("temperature"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("temperatures"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("templer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tendentious"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tenn"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tennessean"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tense"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tensely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("termeer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("terrien"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("terrifically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tesler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tesmer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tessitore"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tessler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tetsuo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("th"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thaddeus"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thalia"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tharpe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thatll"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theater"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theaters"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theatre"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theatres"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("theatrical"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("theatricality"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("theatrically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theism"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("thematically"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thenceforth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thereby"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thered"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("therefore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("theriault"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("thermonuclear"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("therriault"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thielemann"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("thielke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("thirtieth"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("thirtysomething"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("thoene"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("thomasine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("thorpe"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tiananmen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tianjin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tiano"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tiara"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ticklish"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tidewater"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tiedeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tiedemann"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tiers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tietje"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tietmeyer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tietze"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tigue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tijuana"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("timeframe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("timeliness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("timeplex"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("timeshare"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("timetable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("timetables"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("timisoara"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("timothea"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("timpe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("timpone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tingler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tingling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tinkler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tinkling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tipler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tireless"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tiremaker"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tires"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tischler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("titania"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tocqueville"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toddler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toddlers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toews"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toffler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tofte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tokuo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tokyo"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tomaino"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tomasine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tongue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tongued"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tongues"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("toniest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tonnesen"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("torme"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tornabene"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("tornatore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("torque"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("torre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("torturous"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("totzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("touareg"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("touches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tousled"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("towle"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("towne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("townes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trachea"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trademark"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trademarked"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trademarks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tradesmen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("traditionalists"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("traer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tragically"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("traipse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tramiel"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trampe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tranches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transience"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transients"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("transoceanic"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transpired"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("transpires"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trappe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("travelogue"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trbovich"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("treichler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("treml"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trenches"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trendier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trendiest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tressler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tribesmen"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("triennial"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trieu"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("trimedyne"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trimpe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("triomphe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tripling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("trippe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trisler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("troia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("troiani"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tropea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trousdale"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("truell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("truest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("truex"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("truism"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trulove"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trusler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tryin"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tryon"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tryout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tryouts"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trzaska"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("trzcinski"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("trzeciak"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ts"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tsui"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tufte"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tuinstra"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tuition"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("tuitions"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tumbler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tumblers"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("tunde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tunkelang"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turbeville"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("turbocharged"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turcotte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("turquoise"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("turrentine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tvsat"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("twentieth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("twinkling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("tyo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("typecast"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typecasting"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typefaces"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("typeset"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typesetting"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typewriter"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typewriters"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typewriting"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typewritten"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("typically"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uarco"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("uart"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ubiquity"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uehara"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ueki"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uemura"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("uhde"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ukulele"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ulfred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("umpire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("umpires"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("unashamedly"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("uncharacteristically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uncomfortably"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("uncooperative"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("uncoordinated"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unctuous"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("underserved"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("undeserved"));
        $this->assertEquals(7, $this->TextStatistics->syllableCount("undifferentiated"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unearthed"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unexpired"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unfamiliar"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("unfamiliarities"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("unfamiliarity"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("uninitiated"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uninspired"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uninterested"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uninteresting"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uniquely"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uniqueness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unmatched"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unnerved"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("unplugged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unpretentious"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unreasonable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("unreasoning"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("unreimbursed"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("unscientific"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("unsubstantiated"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("untermeyer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("updegrove"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("uplinger"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("urea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("uribe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("urquhart"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("urrea"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("usa"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("usair"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("usameribancs"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("usbancorp"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("usefulness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("usenet"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ustrust"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("uy"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vague"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vaguely"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vagueness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vaguer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valade"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valent"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("valiant"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valiantly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valiente"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valiquette"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("valladares"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valliere"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vallone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valonia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valores"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valuable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("valuables"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vanacore"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vande"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vanderleest"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanderlinde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandermeer"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vandersluis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandervelde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandevelde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandevoorde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vandezande"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanevery"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vanhecke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vanhouten"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vanleer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanleeuwen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanliew"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vanscyoc"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vantine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vardeman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("varietal"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("varnadore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("varrone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vassilios"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vastine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vaudevillian"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vaughan"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vecchione"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("veer"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("veers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vegetable"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vegetables"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("velte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("venneman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("venzke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("verdone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("verduin"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("verine"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vermeer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("veronique"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("versluis"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vertically"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("veterinarian"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("veterinarians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("veterinary"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vexatious"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("viau"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("viceroy"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("victorine"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vidales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vidalia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("viejo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vienna"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("viennese"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("viers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vietcong"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vieth"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vietnam"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vietnamese"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vietti"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vieyra"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vigeland"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("viglione"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vigue"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("villafane"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("villasenor"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("villiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vineland"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vinje"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("violations"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("VIP"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("virginia"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("virginian"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("virginians"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("virkler"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("virtuosity"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("virtuoso"));
        $this->assertEquals(5, $this->TextStatistics->syllableCount("visualization"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("visualize"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("visualizing"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("visually"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("visuals"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("visx"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vitale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vivien"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vizcaino"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vlcek"));
        $this->assertEquals(6, $this->TextStatistics->syllableCount("vnesheconombank"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voce"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vocke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vogl"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("vogue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voicemail"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("voiceworks"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("volcanically"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("volentine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("volpe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("volunteer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("volunteers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vorhauer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vosler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vrba"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("vrdolyak"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vs"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vsel"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("vuolo"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("vuong"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("w"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waage"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wageman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wahle"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waidelich"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wakefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wakeham"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wakeland"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wakeley"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wakeman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("walde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("waleson"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("walfred"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("walke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wanke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wannabe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wannabes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("warbling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("warde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("warehoused"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("warnecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wass"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wastebasket"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wastebaskets"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wastefulness"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wasteland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wastepaper"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wastewater"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("watanabe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("waterlogged"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("watershed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("watling"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("watlington"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("watne"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wavelength"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wavelengths"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wavetek"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("waynesboro"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wedgestone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wedgewood"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wedgeworth"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wednesday"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wednesdays"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wegrzyn"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wehde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weiand"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weide"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weideman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weidemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("weidler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weigl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weinger"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weist"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("welke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wellesley"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("welte"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wempe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wenches"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wende"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wengler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wenke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wente"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wenzl"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weppler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("werdesheim"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wereldhave"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("werent"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("werewolf"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("werke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wermiel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wernecke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wernicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("werre"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("weseman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wesemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wesler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wess"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wessler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("westmoreland"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("weyerhaeuser"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("whatsoever"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whereby"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wherehouse"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wherewithal"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitebread"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("whitecotton"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitefield"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitefish"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteford"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehair"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehall"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehead"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehill"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehorn"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehorse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehouse"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitehurst"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitelaw"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteley"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitelock"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitemont"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitenack"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whiteneir"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitener"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitenight"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("whitescarver"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitesel"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitesell"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitetail"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitewash"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whitewashed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("whitewater"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("whittemore"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("whoever"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wholehearted"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wholeheartedly"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wholesale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wholesaler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wholesalers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wholesales"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wholesaling"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wholesomeness"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("whosoever"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wicke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wickes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wickliffe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("widebody"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wideman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("widespread"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiedeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiedemann"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wienecke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wienke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wiers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiesemann"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wiggly"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wiitala"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wilde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wildeman"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wildes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wildfire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wildfires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wildflowers"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wileman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wilfred"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wilke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wilkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wilkesboro"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("william"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("williams"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamsburg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamsburgh"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamsen"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamson"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamsport"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("williamstown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("williard"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wilmes"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wiltse"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("windes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wineberg"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("winegarden"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wineheim"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wineman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("winemiller"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("winfred"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wingler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("winifred"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wipeout"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wire"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wired"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wireline"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wireman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wires"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiretaps"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wisecarver"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wisecrack"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wisecracking"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wisecracks"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wisecup"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiseguy"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wisehart"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wiseman"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wisler"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wisniewski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wissler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("witte"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("witteman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wittler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("witzke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wlodarczyk"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wlodarski"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wm"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wobbe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wobbly"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wolfe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wolke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wolske"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wolstenholme"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wooed"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("worcester"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wotring"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wouldnt"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("woulfe"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wrangler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wranglers"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wrangling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wrenches"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wrestler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wrinkling"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("writedown"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("writedowns"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("wrzesinski"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("ws"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wuest"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wurdeman"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("wussler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("wylde"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("wyoming"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("xanthe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xantippe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xavier"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("xaviera"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("xian"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xiaoping"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xiaoyun"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xscribe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("xtra"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("xuan"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yaffe"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yahnke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yamaichi"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yamane"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yamatake"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yamauchi"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yanke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yarbrough"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yarde"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yarmulkes"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yasuo"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yearearlier"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yeates"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yerke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yingling"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ynez"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("ynjiun"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("yoichi"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yolande"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yongue"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yonke"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yorio"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("yorke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("yosemite"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("yuletide"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zaccone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zaire"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zairean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zaireans"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zairian"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zairians"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zakrzewski"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zaniewski"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zappone"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zarcone"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zayed"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeidler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeigler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeisler"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zeitler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zemke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zerbe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zeringue"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zettler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zhejiang"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zielke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("ziemke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zier"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zierke"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("ziesmer"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zigler"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zigzagged"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zimbabwean"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zingale"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zingler"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zinke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zirbes"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zoe"));
        $this->assertEquals(2, $this->TextStatistics->syllableCount("zoete"));
        $this->assertEquals(3, $this->TextStatistics->syllableCount("zorine"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zuehlke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zuelke"));
        $this->assertEquals(1, $this->TextStatistics->syllableCount("zuhlke"));
        $this->assertEquals(4, $this->TextStatistics->syllableCount("zuidema"));
    }
}
