LenaJS.gradient = function(deltaX, deltaY) {
  var srcX = deltaX.data,
      canvasWidth = deltaX.width,
      canvasHeight = deltaX.height,
      srcY = deltaY.data,
      temporaryCanvas = document.createElement('canvas'),
      temporaryCtx = temporaryCanvas.getContext('2d'),
      outputData = temporaryCtx.createImageData(canvasWidth, canvasHeight),
      outputDataDir = new Array(srcX.length).fill(0);

  for (var y = 0; y < canvasHeight; y++) {

    for (var x = 0; x < canvasWidth; x++) {

      var dstOff = (y * canvasWidth + x) * 4;

      outputData.data[dstOff] = Math.sqrt(Math.pow(srcX[dstOff], 2) +  Math.pow(srcY[dstOff], 2));
      outputData.data[dstOff+1] = Math.sqrt(Math.pow(srcX[dstOff+1], 2) +  Math.pow(srcY[dstOff+1], 2));
      outputData.data[dstOff+2] = Math.sqrt(Math.pow(srcX[dstOff+2], 2) +  Math.pow(srcY[dstOff+2], 2));
      outputData.data[dstOff+3] = 255;

      outputDataDir[dstOff] = Math.atan2(srcY[dstOff], srcX[dstOff]);
      outputDataDir[dstOff+1] = Math.atan2(srcY[dstOff+1], srcX[dstOff+1]);
      outputDataDir[dstOff+2] = Math.atan2(srcY[dstOff+2], srcX[dstOff+2]);
      outputDataDir[dstOff+3] = 255;
    }
  }
  result = {magnitude: outputData, direction: outputDataDir};
  return result;
};
