/*
 *  lena-js - v0.0.1
 *  Library for image processing
 *  https://github.com/davidsonfellipe/lena-js/
 *
 *  Made by Davidson Fellipe
 *  Under MIT License
 */
// http://www.w3.org/html/wg/drafts/2dcontext/html5_canvas/
var LenaJS={};LenaJS.getImage=function(a){var t=document.createElement("canvas");t.width=a.width,t.height=a.height;var n=t.getContext("2d");return n.drawImage(a,0,0),n.getImageData(0,0,a.width,a.height)},LenaJS.printCanvas=function(a,t){a.width=t.width,a.height=t.height,a.getContext("2d").putImageData(t,0,0)},LenaJS.filterImage=function(a,t,n){var e=[this.getImage(n)];return this.printCanvas(a,t.apply(null,e))},LenaJS.redrawCanvas=function(a,t){var n=a.getContext("2d");return n=[n.getImageData(0,0,a.width,a.height)],this.printCanvas(a,t.apply(null,n))},LenaJS.convolution=function(a,t){for(var n=Math.round(Math.sqrt(t.length)),e=Math.floor(n/2),r=a.data,o=a.width,i=a.height,d=document.createElement("canvas").getContext("2d").createImageData(o,i),u=0;u<i;u++)for(var h=0;h<o;h++){for(var c=4*(u*o+h),v=0,l=0,g=0,s=0;s<n;s++)for(var f=0;f<n;f++){var S=u+s-e,J=h+f-e;if(S>=0&&S<i&&J>=0&&J<o){var L=4*(S*o+J),m=t[s*n+f];v+=r[L]*m,l+=r[L+1]*m,g+=r[L+2]*m}}d.data[c]=v,d.data[c+1]=l,d.data[c+2]=g,d.data[c+3]=255}return d},LenaJS.gradient=function(a,t){for(var n=a.data,e=a.width,r=a.height,o=t.data,i=document.createElement("canvas").getContext("2d").createImageData(e,r),d=new Array(n.length).fill(0),u=0;u<r;u++)for(var h=0;h<e;h++){var c=4*(u*e+h);i.data[c]=Math.sqrt(Math.pow(n[c],2)+Math.pow(o[c],2)),i.data[c+1]=Math.sqrt(Math.pow(n[c+1],2)+Math.pow(o[c+1],2)),i.data[c+2]=Math.sqrt(Math.pow(n[c+2],2)+Math.pow(o[c+2],2)),i.data[c+3]=255,d[c]=Math.atan2(o[c],n[c]),d[c+1]=Math.atan2(o[c+1],n[c+1]),d[c+2]=Math.atan2(o[c+2],n[c+2]),d[c+3]=255}return result={magnitude:i,direction:d},result},LenaJS.histogram=function(a){"use strict";for(var t=this.getImage(a),n=new Array(257).join("0").split(""),e={r:n.map(Number),g:n.map(Number),b:n.map(Number)},r=0;r<t.data.length;r+=4)e.r[t.data[r]]++,e.g[t.data[r+1]]++,e.b[t.data[r+2]]++;return e},LenaJS.nonMaximumSuppression=function(a,t){for(var n=Math.round(Math.sqrt(25)),e=Math.floor(n/2),r=a.data,o=a.width,i=a.height,d=document.createElement("canvas").getContext("2d").createImageData(o,i),u=0;u<i;u++)for(var h=0;h<o;h++){for(var c=4*(u*o+h),v=r[c],l=r[c+1],g=r[c+2],s=(r[c+3],0);s<n;s++)for(var f=0;f<n;f++){var S=u+s-e,J=h+f-e;if(S>=0&&S<i&&J>=0&&J<o){var L=4*(S*o+J),m=Math.atan2(S-u,J-h);v=r[L]*Math.abs(Math.cos(t[c]-m))>v?0:v,l=r[L+1]*Math.abs(Math.cos(t[c+1]-m))>l?0:l,g=r[L+2]*Math.abs(Math.cos(t[c+2]-m))>g?0:g}}d.data[c]=2*v,d.data[c+1]=2*l,d.data[c+2]=2*g,d.data[c+3]=255}return d},LenaJS.bigGaussian=function(a,t){var n=[2/159,4/159,5/159,4/159,2/159,4/159,9/159,12/159,9/159,4/159,5/159,12/159,15/159,12/159,5/159,4/159,9/159,12/159,9/159,4/159,2/159,4/159,5/159,4/159,2/159];return LenaJS.convolution(a,n)},LenaJS.canny=function(a,t){a=LenaJS.bigGaussian(a);var n=LenaJS.sobelHorizontal(a),e=LenaJS.sobelVertical(a),r=LenaJS.gradient(n,e),o=LenaJS.laplacian(a);return a=LenaJS.nonMaximumSuppression(o,r.direction),LenaJS.thresholding(a,8)},LenaJS.gaussian=function(a,t){var n=[1/16,.125,1/16,.125,.25,.125,1/16,.125,1/16];return LenaJS.convolution(a,n)},LenaJS.grayscale=function(a,t){for(var n=0;n<a.data.length;n+=4){var e=a.data[n],r=a.data[n+1],o=a.data[n+2];a.data[n]=a.data[n+1]=a.data[n+2]=.2126*e+.7152*r+.0722*o}return a},LenaJS.highpass=function(a,t){var n=[-1,-1,-1,-1,8,-1,-1,-1,-1];return LenaJS.convolution(a,n)},LenaJS.invert=function(a,t){for(var n=0;n<a.data.length;n+=4)a.data[n]=255-a.data[n],a.data[n+1]=255-a.data[n+1],a.data[n+2]=255-a.data[n+2];return a},LenaJS.laplacian=function(a,t){var n=[0,-1,0,-1,4,-1,0,-1,0];return LenaJS.convolution(a,n)},LenaJS.lowpass3=function(a,t){var n=1/9,e=[n,n,n,n,n,n,n,n,n];return LenaJS.convolution(a,e)},LenaJS.lowpass5=function(a,t){var n=.04,e=[n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n,n];return LenaJS.convolution(a,e)},LenaJS.prewittHorizontal=function(a,t){var n=[1/3,1/3,1/3,0,0,0,-1/3,-1/3,-1/3];return LenaJS.convolution(a,n)},LenaJS.prewittVertical=function(a,t){var n=[-1/3,0,1/3,-1/3,0,1/3,-1/3,0,1/3];return LenaJS.convolution(a,n)},LenaJS.red=function(a,t){for(var n=a.data,e=0;e<n.length;e+=4)n[e]=n[e],n[e+1]=0,n[e+2]=0;return a},LenaJS.green=function(a,t){for(var n=a.data,e=0;e<n.length;e+=4)n[e]=0,n[e+2]=0;return a},LenaJS.blue=function(a,t){for(var n=a.data,e=0;e<n.length;e+=4)n[e]=0,n[e+1]=0;return a},LenaJS.roberts=function(a,t){var n=[0,0,0,1,-1,0,0,0,0];return LenaJS.convolution(a,n)},LenaJS.saturation=function(a,t){for(var n=0;n<a.data.length;n+=4)a.data[n]=2.31366*a.data[n]+-1.15596*a.data[n+1]+-.1558*a.data[n+2],a.data[n+1]=-.58634*a.data[n]+(2.9-1.15596)*a.data[n+1]+-.1558*a.data[n+2],a.data[n+2]=-.58634*a.data[n]+-1.15596*a.data[n+1]+(2.9-.1558)*a.data[n+2];return a},LenaJS.sepia=function(a,t){for(var n=0;n<a.data.length;n+=4){var e=a.data[n],r=a.data[n+1],o=a.data[n+2];a.data[n]=a.data[n+1]=a.data[n+2]=.3*e+.59*r+.11*o,a.data[n]+=40,a.data[n+1]+=20,a.data[n+2]-=20}return a},LenaJS.sharpen=function(a,t){var n=[0,-.2,0,-.2,1.8,-.2,0,-.2,0];return LenaJS.convolution(a,n)},LenaJS.sobelHorizontal=function(a,t){var n=[.25,.5,.25,0,0,0,-.25,-.5,-.25];return a=LenaJS.convolution(a,n)},LenaJS.sobelVertical=function(a,t){var n=[.25,0,-.25,.5,0,-.5,.25,0,-.25];return a=LenaJS.convolution(a,n)},LenaJS.thresholding=function(a,t){for(var n=0;n<a.data.length;n+=4){var e=.2126*a.data[n]+.7152*a.data[n+1]+.0722*a.data[n+2];thr=t||128,a.data[n]=a.data[n+1]=a.data[n+2]=e>thr?255:0}return a};