﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using PagerDemo.Navigation;

namespace PagerDemo
{
    public class Startup
    {
        public Startup(IHostingEnvironment env)
        {
            var builder = new ConfigurationBuilder()
                .SetBasePath(env.ContentRootPath)
                .AddJsonFile("appsettings.json");

            Configuration = builder.Build();
        }

        private IConfiguration Configuration { get; set; }

        public void ConfigureServices(IServiceCollection service)
        {
            service.AddMvc();

            service.AddSingleton(Configuration)
                .AddTransient(typeof(IPageHelper<>), typeof(PageHelper<>))
                .AddSingleton<IPageConfig, PageConfig>();
        }

        public void Configure(IApplicationBuilder app, IHostingEnvironment env)
        {
            app.UseDeveloperExceptionPage();

            app.UseStaticFiles();

            app.UseMvc(config => config.MapRoute("default", "{controller=Home}/{action=Index}/{id?}"));

            app.Run(handler => handler.Response.WriteAsync("Page not find."));
        }
    }
}