﻿using Microsoft.AspNetCore.Mvc;
using PagerDemo.DbContext;
using PagerDemo.Navigation;
using PagerDemo.ViewModels;

namespace PagerDemo.Controllers
{
    public class HomeController : Controller
    {
        private EmployeeDbContext _dbContext;
        private IPageHelper<EmployeeViewModel> _pageHelper;

        public HomeController(IPageHelper<EmployeeViewModel> pageHelper)
        {
            _dbContext = new EmployeeDbContext();
            _pageHelper = pageHelper;
        }

        [HttpGet]
        public IActionResult Index(int pageNumber = 1)
        {
            var allEmployees = _dbContext.GetEmployees();

            var result = _pageHelper.GetPage(allEmployees, pageNumber);

            var employees = new EmployeePageViewModel
            {
                Employees = result.Items,
                Pager = result.Pager
            };

            return View(employees);
        }
    }
}