﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Default.aspx.cs" Inherits="SampleGridViewApplication.Default" %>

<%@ Register Assembly="CSDRGridView" Namespace="CSDRGridView.Controls" TagPrefix="cc1" %>
<%@ Register Assembly="CSDRGridView" Namespace="CSDRGridView.Controls.Fields" TagPrefix="cc1" %>

<!DOCTYPE html>
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <title></title>
</head>
<body>
    <form id="form1" runat="server">
        <div>
            Sample Custom DataGridView Application<br />
            <cc1:GridView ID="gvCSDRPagerName" runat="server" CustomPagerSettingsMode="CSDRPager" 
                CustomSkin="GreyBlackWhite" DataKeyNames="BusinessEntityID" DefaultSecurity="Admin" 
                ToolTipAddButton="Add Test" 
                ToolTipCloseExportWindow="Close Export Window" 
                ToolTipCloseFilterWindow ="Close Filter Window"
                ToolTipDeleteButton="Delete Item"
                ToolTipEditButton="Edit Item"
                ToolTipExportCSV="CSV Export"
                ToolTipExportExcel="Excel Export"
                ToolTipExportHTML="HTML Export"
                ToolTipExportPDF="PDF Export"
                ToolTipExportWord="Word Export"
                ToolTipExtractButton="Extract Data"
                ToolTipFirstPageButton="First Page"
                ToolTipLastPageButton="Last Page"
                ToolTipNextPageButton="Next Page"
                ToolTipPrevPageButton="Prev Page"
                ToolTipRefreshButton="Refresh Page"
                ToolTipSearchButton="Search Data"
                ToolTipViewButton="View Item"
                ToolTipFilterWindowDeleteFilterText="Delete Filter"
                ToolTipFilterWindowSaveFilterOptionText="Save Filter"

                FilterWindowAddFilterText="Add Filter"
                FilterWindowAddFilterDropDownFieldSelectText="---Select---"
                FilterWindowCurrentFiltersHeaderText="Current Filters"
                FilterWindowHeaderText="Header Test"             

                ShowChartButton="true"
                TableTitle="Sample GridView Data">
                
                <PagerSettings Position="TopAndBottom" />
                <EmptyDataTemplate>
                    There are no users defined for the table...
                </EmptyDataTemplate>
                <Columns>
                    <cc1:BoundField DataField="BusinessEntityID" HeaderText="ID" HeaderStyle-Width="20" SortExpression="BusinessEntityID" ShowOnExtract="true" />
                    <cc1:BoundField DataField="Title" HeaderText="Title" HeaderStyle-Width="60" SortExpression="Title" ShowOnExtract="true" />
                    <cc1:BoundField DataField="FirstName" HeaderText="First Name" HeaderStyle-Width="100" SortExpression="FirstName" ShowOnExtract="True" />
                    <cc1:BoundField DataField="LastName" HeaderText="Last Name" HeaderStyle-Width="100" SortExpression="LastName" ShowOnExtract="True" />
                    <cc1:BoundField DataField="EmailAddress" HeaderText="Email" SortExpression="EmailAddress" ShowOnExtract="True" />
                    <cc1:BoundField DataField="AddressLine1" HeaderText="Address" SortExpression="AddressLine1" ShowOnExtract="True" />
                    <cc1:BoundField DataField="City" HeaderText="City" SortExpression="City" ShowOnExtract="True" />
                    <cc1:BoundField DataField="StateProvinceName" HeaderText="State" SortExpression="StateProvinceName" ShowOnExtract="True" />
                    <cc1:BoundField DataField="CountryRegionName" HeaderText="Country" SortExpression="CountryRegionName" ShowOnExtract="True" />
                    <cc1:BoundField DataField="PostalCode" HeaderText="Zip Code" HeaderStyle-Width="60" SortExpression="PostalCode" ShowOnExtract="True" />
                </Columns>
            </cc1:GridView>
        </div>
    </form>
</body>
</html>
