# Summary

- [xlsx](README.md#sheetjs-js-xlsx)
- [Installation](README.md#installation)
  * [JS Ecosystem Demos](README.md#js-ecosystem-demos)
  * [Optional Modules](README.md#optional-modules)
  * [ECMAScript 5 Compatibility](README.md#ecmascript-5-compatibility)
- [Philosophy](README.md#philosophy)
- [Parsing Workbooks](README.md#parsing-workbooks)
  * [Parsing Examples](README.md#parsing-examples)
  * [Streaming Read](README.md#streaming-read)
- [Working with the Workbook](README.md#working-with-the-workbook)
  * [Parsing and Writing Examples](README.md#parsing-and-writing-examples)
- [Writing Workbooks](README.md#writing-workbooks)
  * [Writing Examples](README.md#writing-examples)
  * [Streaming Write](README.md#streaming-write)
- [Interface](README.md#interface)
  * [Parsing functions](README.md#parsing-functions)
  * [Writing functions](README.md#writing-functions)
  * [Utilities](README.md#utilities)
- [Common Spreadsheet Format](README.md#common-spreadsheet-format)
  * [General Structures](README.md#general-structures)
  * [Cell Object](README.md#cell-object)
    + [Data Types](README.md#data-types)
    + [Dates](README.md#dates)
  * [Sheet Objects](README.md#sheet-objects)
    + [Worksheet Object](README.md#worksheet-object)
    + [Chartsheet Object](README.md#chartsheet-object)
  * [Workbook Object](README.md#workbook-object)
    + [Workbook File Properties](README.md#workbook-file-properties)
  * [Workbook-Level Attributes](README.md#workbook-level-attributes)
    + [Defined Names](README.md#defined-names)
    + [Miscellaneous Workbook Properties](README.md#miscellaneous-workbook-properties)
  * [Document Features](README.md#document-features)
    + [Formulae](README.md#formulae)
    + [Column Properties](README.md#column-properties)
    + [Row Properties](README.md#row-properties)
    + [Number Formats](README.md#number-formats)
    + [Hyperlinks](README.md#hyperlinks)
    + [Cell Comments](README.md#cell-comments)
    + [Sheet Visibility](README.md#sheet-visibility)
- [Parsing Options](README.md#parsing-options)
  * [Input Type](README.md#input-type)
  * [Guessing File Type](README.md#guessing-file-type)
- [Writing Options](README.md#writing-options)
  * [Supported Output Formats](README.md#supported-output-formats)
  * [Output Type](README.md#output-type)
- [Utility Functions](README.md#utility-functions)
  * [Array of Arrays Input](README.md#array-of-arrays-input)
  * [Array of Objects Input](README.md#array-of-objects-input)
  * [HTML Table Input](README.md#html-table-input)
  * [Formulae Output](README.md#formulae-output)
  * [Delimiter-Separated Output](README.md#delimiter-separated-output)
    + [UTF-16 Unicode Text](README.md#utf-16-unicode-text)
  * [HTML Output](README.md#html-output)
  * [JSON](README.md#json)
- [File Formats](README.md#file-formats)
  * [Excel 2007+ XML (XLSX/XLSM)](README.md#excel-2007-xml-xlsxxlsm)
  * [Excel 2.0-95 (BIFF2/BIFF3/BIFF4/BIFF5)](README.md#excel-20-95-biff2biff3biff4biff5)
  * [Excel 97-2004 Binary (BIFF8)](README.md#excel-97-2004-binary-biff8)
  * [Excel 2003-2004 (SpreadsheetML)](README.md#excel-2003-2004-spreadsheetml)
  * [Excel 2007+ Binary (XLSB, BIFF12)](README.md#excel-2007-binary-xlsb-biff12)
  * [Delimiter-Separated Values (CSV/TXT)](README.md#delimiter-separated-values-csvtxt)
  * [Other Workbook Formats](README.md#other-workbook-formats)
    + [Lotus 1-2-3 (WKS/WK1/WK2/WK3/WK4/123)](README.md#lotus-1-2-3-wkswk1wk2wk3wk4123)
    + [Quattro Pro (WQ1/WQ2/WB1/WB2/WB3/QPW)](README.md#quattro-pro-wq1wq2wb1wb2wb3qpw)
    + [OpenDocument Spreadsheet (ODS/FODS)](README.md#opendocument-spreadsheet-odsfods)
    + [Uniform Office Spreadsheet (UOS1/2)](README.md#uniform-office-spreadsheet-uos12)
  * [Other Single-Worksheet Formats](README.md#other-single-worksheet-formats)
    + [dBASE and Visual FoxPro (DBF)](README.md#dbase-and-visual-foxpro-dbf)
    + [Symbolic Link (SYLK)](README.md#symbolic-link-sylk)
    + [Lotus Formatted Text (PRN)](README.md#lotus-formatted-text-prn)
    + [Data Interchange Format (DIF)](README.md#data-interchange-format-dif)
    + [HTML](README.md#html)
- [Testing](README.md#testing)
  * [Node](README.md#node)
  * [Browser](README.md#browser)
  * [Tested Environments](README.md#tested-environments)
  * [Test Files](README.md#test-files)
- [Contributing](README.md#contributing)
  * [OSX/Linux](README.md#osxlinux)
  * [Windows](README.md#windows)
  * [Tests](README.md#tests)
- [License](README.md#license)
- [References](README.md#references)
