﻿using System;
using System.Collections.Generic;
using FluentNHibernate.Cfg;
using FluentNHibernate.Cfg.Db;
using NHibernate;

namespace MasterChefWebApp.Models
{
    public sealed class Repository
    {
        ISessionFactory _sessionFactory;
        ISession _session;

        private static readonly Repository _instance = new Repository();

        private Repository()
        {
            InitializeSession();
        }

        public static Repository Instance
        {
            get
            {
                return _instance;
            }
        }

        void InitializeSession()
        {
            try
            {
                _sessionFactory = Fluently.Configure()
                    .Database(MsSqlConfiguration.MsSql2012
                    .ConnectionString("Server=.\\sqlexpress; Database=MasterChef; Integrated Security=SSPI;"))
                    .Mappings(m => m
                    .FluentMappings.AddFromAssemblyOf<Repository>())
                    .BuildSessionFactory();
                _session = _sessionFactory.OpenSession();
            }
            catch (Exception ex)
            {
                throw ex;
            }


        }

        public IList<Recipe> GetAllRecipes()
        {
            try
            {
                return _session.QueryOver<Recipe>().List();
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public Recipe GetRecipe(Guid id)
        {
            try
            {
                return _session.Get<Recipe>(id);
            }
            catch (Exception ex)
            {
                throw ex;
            }
        }

        public Recipe AddRecipe(Recipe recipe)
        {
            Recipe entity = null;
            using (var transaction = _session.BeginTransaction())
            {
                try
                {
                    recipe.RecipeId = Guid.NewGuid();
                    recipe.ModifyDate = DateTime.Now;
                    entity = _session.Save(recipe) as Recipe;
                    transaction.Commit();
                }
                catch (StaleObjectStateException ex)
                {
                    try
                    {
                        entity = _session.Merge(recipe);
                        transaction.Commit();
                    }
                    catch
                    {
                        transaction.Rollback();
                        throw;
                    }
                }
                return entity;
            }
        }

        public void UpdateRecipe(Recipe recipe)
        {
            using (var transaction = _session.BeginTransaction())
            {
                try
                {
                    _session.Update(recipe);
                    transaction.Commit();
                }
                catch (StaleObjectStateException ex)
                {
                    try
                    {
                        _session.Merge(recipe);
                        transaction.Commit();
                    }
                    catch
                    {
                        transaction.Rollback();
                        throw;
                    }
                }

            }
        }

        public void DeleteRecipe(Guid id)
        {
            using (var transaction = _session.BeginTransaction())
            {
                var recipe = _session.Get<Recipe>(id);
                if (recipe != null)
                {
                    try
                    {
                        _session.Delete(recipe);
                        transaction.Commit();
                    }
                    catch (StaleObjectStateException ex)
                    {
                        try
                        {
                            _session.Merge(recipe);
                            transaction.Commit();
                        }
                        catch
                        {
                            transaction.Rollback();
                            throw;
                        }
                    }
                }
            }
        }
    }
}
