﻿using System.Web.Mvc;

namespace ExceptionHandling.App_Start
{
    public class CustomErrorHandler : HandleErrorAttribute
    {
        public override void OnException(ExceptionContext exceptionContext)
        {
            if (!exceptionContext.ExceptionHandled)
            {
                string controllerName = (string)exceptionContext.RouteData.Values["controller"];
                string actionName = (string)exceptionContext.RouteData.Values["action"];
                var model = new HandleErrorInfo(exceptionContext.Exception, controllerName, actionName);

                //This code shows the attribute where we redirect from Filter
                exceptionContext.Result = new ViewResult
                {
                    ViewName = "ActionName of CustomError Page Name",
                    ViewData = new ViewDataDictionary<HandleErrorInfo>(model),
                    TempData = exceptionContext.Controller.TempData
                };
            }
        }
    }
}