import { distance } from "./math.js";

export default function(ring, vs) {

  let len = ring.length,
      min = Infinity,
      bestOffset,
      sumOfSquares,
      spliced;

  for (let offset = 0; offset < len; offset++) {

    sumOfSquares = 0;

    vs.forEach(function(p, i){
      let d = distance(ring[(offset + i) % len], p);
      sumOfSquares += d * d;
    });

    if (sumOfSquares < min) {
      min = sumOfSquares;
      bestOffset = offset;
    }

  }

  if (bestOffset) {
    spliced = ring.splice(0, bestOffset);
    ring.splice(ring.length, 0, ...spliced);
  }

}
