﻿using System;
using System.Collections.Generic;

namespace SerializeObjectReference.Models
{
    public class Branch
    {
        public string Code { get; set; }
        public Branch HeadOffice { get; set; }
        public Bank Bank { get; set; }
        public string City { get; set; }

        public static Branch getBranch(string city, string address, Branch headOffice)
        {
            Random random = new Random();
            var branch = new Branch
            {
                Bank = Bank.GetBank(),
                Code = "IN-" + city + "-" + random.Next().ToString(),
                City = city
            };
            branch.HeadOffice = headOffice ?? branch;
            return branch;
        }

        public static IEnumerable<Branch> GetAllBranches()
        {
            var branches = new List<Branch>();
            var headOffice = Branch.getBranch("Delhi", "Delhi - 01", null);
            branches.Add(headOffice);
            branches.Add(Branch.getBranch("Delhi", "Delhi - 02", headOffice));
            branches.Add(Branch.getBranch("Delhi", "Delhi - 03", headOffice));
            branches.Add(Branch.getBranch("Noida", "UP", headOffice));
            branches.Add(Branch.getBranch("Greater Noida", "UP", headOffice));
            branches.Add(Branch.getBranch("Gurgaon", "Haryana", headOffice));
            return branches;
        }

    }
}