﻿using System;
using System.Collections.Generic;

namespace SerializeObjectReference.Models
{
    public class Account
    {
        public string AccountNumber { get; set; }
        public float Balance { get; set; }
        public DateTime OpeningDate { get; set; }
        public Branch Branch { get; set; }
        public Customer Customer { get; set; }

        public static Account getAccount(float balance, Branch branch)
        {
            Random random = new Random();
            var account = new Account
            {
                AccountNumber = "IN-" + random.Next().ToString(),
                Balance = balance,
                OpeningDate = DateTime.Now,
                Branch = branch,
            };
            return account;
        }

        public static IEnumerable<Account> GetAllAccounts()
        {
            var accounts = new List<Account>();
            var delhiBranch = Branch.getBranch("Delhi", "Delhi-01", null);
            var gurgaonBranch = Branch.getBranch("Gurgaon", "Haryana", null);
            accounts.Add(Account.getAccount(0, delhiBranch));
            accounts.Add(Account.getAccount(10, delhiBranch));
            accounts.Add(Account.getAccount(20, delhiBranch));
            accounts.Add(Account.getAccount(30, delhiBranch));
            accounts.Add(Account.getAccount(40, gurgaonBranch));
            accounts.Add(Account.getAccount(50, gurgaonBranch));
            return accounts;
        }
    }

}