﻿using Newtonsoft.Json;
using Newtonsoft.Json.Linq;
using SerializeObjectReference.Models;
using System.Collections.Generic;
using System.Net;
using System.Net.Http;
using System.Web.Http;

namespace SerializeObjectReference.Controllers
{
    public class BranchApiController : ApiController
    {
        // GET api/GetAllBranches
        public HttpResponseMessage GetAllBranches()
        {
            var branches = Branch.GetAllBranches();
            string json = JsonConvert.SerializeObject(branches, Formatting.Indented, new JsonSerializerSettings { PreserveReferencesHandling = PreserveReferencesHandling.Objects });
            return Request.CreateResponse(HttpStatusCode.OK, json);
        }

        // POST api/PostBranches
        public HttpResponseMessage PostBranches(JObject jsonData)
        {
            dynamic m = jsonData;
            string jBranches = m.branches.Value as string;

            List<Branch> deserializedBranches = JsonConvert.DeserializeObject<List<Branch>>(jBranches, new JsonSerializerSettings { PreserveReferencesHandling = PreserveReferencesHandling.Objects });

            return Request.CreateResponse(HttpStatusCode.OK);
        }


        // GET api/GetAllAccounts
        public HttpResponseMessage GetAllAccounts()
        {
            var accounts = Account.GetAllAccounts();
            string json = JsonConvert.SerializeObject(accounts, Formatting.Indented, new JsonSerializerSettings { PreserveReferencesHandling = PreserveReferencesHandling.Objects });
            return Request.CreateResponse(HttpStatusCode.OK, json);
        }

        // POST api/PostAccounts
        public HttpResponseMessage PostAccounts(JObject jsonData)
        {
            dynamic m = jsonData;
            string jAccounts = m.accounts.Value as string;

            List<Account> deserializedAccounts = JsonConvert.DeserializeObject<List<Account>>(jAccounts, new JsonSerializerSettings { PreserveReferencesHandling = PreserveReferencesHandling.Objects });

            HttpResponseMessage response = Request.CreateResponse(HttpStatusCode.OK);
            return response;
        }
    }
}