﻿/// <reference path="../typings/jquery/jquery.d.ts" />
/// <reference path="../typings/gijgo/gijgo.d.ts" />

interface IPlayer {
    ID: number;
    Name: string;
    PlaceOfBirth: string;
    DateOfBirth: Date;
}

class SiteViewModel {

    private model: SiteModel;
    private grid: Gijgo.Grid<IPlayer, any>;
    private dialog: Gijgo.Dialog;

    constructor(model: SiteModel) {
        this.model = model;

        this.grid = $('#grid').grid({
            primaryKey: 'ID',
            columns: [
                { field: 'ID', width: 50, sortable: true },
                { field: 'Name', sortable: true },
                { field: 'PlaceOfBirth', title: 'Place Of Birth', sortable: true },
                { field: 'DateOfBirth', title: 'Date Of Birth', type: 'date', sortable: true },
                { title: '', field: 'Edit', width: 30, align: 'center', type: 'icon', icon: 'fa fa-pencil', tooltip: 'Edit', events: { 'click': (e) => this.edit(e) } },
                { title: '', field: 'Delete', width: 30, align: 'center', type: 'icon', icon: 'fa fa-remove', tooltip: 'Delete', events: { 'click': (e) => this.remove(e) } }
            ],
            pager: { limit: 5 }
        });

        this.dialog = $('#playerModal').dialog({
            autoOpen: false,
            title: 'Player',
            width: 400,
            height: 260
        });

        $('#btnAddPlayer').click(() => this.add());
        $('#btnSave').click(() => this.save());
        $('#btnSearch').click(() => this.search());
    }

    add() {
        $('#playerId').val('');
        $('#name').val('');
        $('#placeOfBirth').val('');
        $('#dateOfBirth').val('');
        this.dialog.open();
    }

    edit(e: any) {
        $('#playerId').val(e.data.id);
        $('#name').val(e.data.record.Name);
        $('#placeOfBirth').val(e.data.record.PlaceOfBirth);
        $('#dateOfBirth').val(e.data.record.DateOfBirth);
        this.dialog.open();
    }

    remove(e: any) {
        this.model.remove(e.data.id, (response) => { this.grid.reload(); }, function () { alert('Unable to remove.'); });
    }

    save() {
        var player: IPlayer = {
                ID: $('#playerId').val(),
                Name: $('#name').val(),
                PlaceOfBirth: $('#placeOfBirth').val(),
                DateOfBirth: $('#dateOfBirth').val()
            },
            onDone = (response) => {
                this.grid.reload();
                this.dialog.close();
            },
            onFail = (response) => {
                alert('Unable to save.');
                this.dialog.close();
            };
        this.model.save(player, onDone, onFail);
    }

    search() {
        this.grid.reload({ searchString: $('#search').val() });
    }
}

class SiteModel {
    save(player: IPlayer, onDone, onFail) {
        $.ajax({ url: 'Home/Save', type: 'POST', data: { player: player } }).done(onDone).fail(onFail);
    }

    remove(id: number, onDone, onFail) {
        $.ajax({ url: 'Home/Remove', type: 'POST', data: { id: id } }).done(onDone).fail(onFail);
    }
}

$(document).ready(function () {
    new SiteViewModel(new SiteModel());
});