/// <reference path="../typings/jquery/jquery.d.ts" />
/// <reference path="../typings/gijgo/gijgo.d.ts" />
var SiteViewModel = (function () {
    function SiteViewModel(model) {
        var _this = this;
        this.model = model;
        this.grid = $('#grid').grid({
            primaryKey: 'ID',
            columns: [
                { field: 'ID', width: 50, sortable: true },
                { field: 'Name', sortable: true },
                { field: 'PlaceOfBirth', title: 'Place Of Birth', sortable: true },
                { field: 'DateOfBirth', title: 'Date Of Birth', type: 'date', sortable: true },
                { title: '', field: 'Edit', width: 30, align: 'center', type: 'icon', icon: 'fa fa-pencil', tooltip: 'Edit', events: { 'click': function (e) { return _this.edit(e); } } },
                { title: '', field: 'Delete', width: 30, align: 'center', type: 'icon', icon: 'fa fa-remove', tooltip: 'Delete', events: { 'click': function (e) { return _this.remove(e); } } }
            ],
            pager: { limit: 5 }
        });
        this.dialog = $('#playerModal').dialog({
            autoOpen: false,
            title: 'Player',
            width: 400,
            height: 260
        });
        $('#btnAddPlayer').click(function () { return _this.add(); });
        $('#btnSave').click(function () { return _this.save(); });
        $('#btnSearch').click(function () { return _this.search(); });
    }
    SiteViewModel.prototype.add = function () {
        $('#playerId').val('');
        $('#name').val('');
        $('#placeOfBirth').val('');
        $('#dateOfBirth').val('');
        this.dialog.open();
    };
    SiteViewModel.prototype.edit = function (e) {
        $('#playerId').val(e.data.id);
        $('#name').val(e.data.record.Name);
        $('#placeOfBirth').val(e.data.record.PlaceOfBirth);
        $('#dateOfBirth').val(e.data.record.DateOfBirth);
        this.dialog.open();
    };
    SiteViewModel.prototype.remove = function (e) {
        var _this = this;
        this.model.remove(e.data.id, function (response) { _this.grid.reload(); }, function () { alert('Unable to remove.'); });
    };
    SiteViewModel.prototype.save = function () {
        var _this = this;
        var player = {
            ID: $('#playerId').val(),
            Name: $('#name').val(),
            PlaceOfBirth: $('#placeOfBirth').val(),
            DateOfBirth: $('#dateOfBirth').val()
        }, onDone = function (response) {
            _this.grid.reload();
            _this.dialog.close();
        }, onFail = function (response) {
            alert('Unable to save.');
            _this.dialog.close();
        };
        this.model.save(player, onDone, onFail);
    };
    SiteViewModel.prototype.search = function () {
        this.grid.reload({ searchString: $('#search').val() });
    };
    return SiteViewModel;
}());
var SiteModel = (function () {
    function SiteModel() {
    }
    SiteModel.prototype.save = function (player, onDone, onFail) {
        $.ajax({ url: 'Home/Save', type: 'POST', data: { player: player } }).done(onDone).fail(onFail);
    };
    SiteModel.prototype.remove = function (id, onDone, onFail) {
        $.ajax({ url: 'Home/Remove', type: 'POST', data: { id: id } }).done(onDone).fail(onFail);
    };
    return SiteModel;
}());
$(document).ready(function () {
    new SiteViewModel(new SiteModel());
});
