﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.PlatformAbstractions;
using ASPNETCore1_TypeScript_Gijgo.Models;
using ASPNETCore1_TypeScript_Gijgo.Helpers;

// For more information on enabling MVC for empty projects, visit http://go.microsoft.com/fwlink/?LinkID=397860

namespace ASPNETCore1_TypeScript_Gijgo.Controllers
{
    public class HomeController : Controller
    {
        private ApplicationDbContext _context;

        public HomeController(ApplicationDbContext context)
        {
            this._context = context;
        }

        // GET: /<controller>/
        public IActionResult Index()
        {
            return View();
        }

        public JsonResult GetPlayers(int? page, int? limit, string sortBy, string direction, string searchString = null)
        {
            var records = this._context.Players.AsQueryable<Player>();

            if (!string.IsNullOrWhiteSpace(searchString))
            {
                records = records.Where(p => p.Name.Contains(searchString) || p.PlaceOfBirth.Contains(searchString));
            }

            int total = records.Count();

            if (!string.IsNullOrEmpty(sortBy) && !string.IsNullOrEmpty(direction))
            {
                if (direction.Trim().ToLower() == "asc")
                {
                    records = SortHelper.OrderBy(records, sortBy);
                }
                else
                {
                    records = SortHelper.OrderByDescending(records, sortBy);
                }
            }

            if (page.HasValue && limit.HasValue)
            {
                int start = (page.Value - 1) * limit.Value;
                records = records.Skip(start).Take(limit.Value);
            }

            return Json(new { records, total });
        }

        [HttpPost]
        public JsonResult Save(Player player)
        {
            if (player.ID > 0)
            {
                var entity = this._context.Players.First(p => p.ID == player.ID);
                entity.Name = player.Name;
                entity.PlaceOfBirth = player.PlaceOfBirth;
                entity.DateOfBirth = player.DateOfBirth;
            }
            else
            {
                this._context.Players.Add(new Player
                {
                    Name = player.Name,
                    PlaceOfBirth = player.PlaceOfBirth,
                    DateOfBirth = player.DateOfBirth
                });
            }
            this._context.SaveChanges();
            return Json(true);
        }

        [HttpPost]
        public JsonResult Remove(int id)
        {
            var entity = this._context.Players.First(p => p.ID == id);
            this._context.Players.Remove(entity);
            this._context.SaveChanges();
            return Json(true);
        }
    }
}
