﻿/// <binding AfterBuild='angular, angular2InMemoryWebApi, libs, rxjs' Clean='clean' />
var gulp = require('gulp');
var rimraf = require('rimraf');

var paths = {
    npm: './node_modules/',
    angular: './wwwroot/lib/@angular/',
    angular2InMemoryWebApi: './wwwroot/lib/angular2-in-memory-web-api/',
    rxjs: './wwwroot/lib/rxjs/',
    lib: './wwwroot/lib/'
};

var angular = [
    paths.npm + '@angular/**/*'
];

var angular2InMemoryWebApi = [
    paths.npm + 'angular2-in-memory-web-api/**/*'
];

var rxjs = [
    paths.npm + 'rxjs/**/*'
];

var libs = [
    paths.npm + 'core-js/client/shim.min.js',
    paths.npm + 'zone.js/dist/zone.js',
    paths.npm + 'reflect-metadata/Reflect.js',
    paths.npm + 'systemjs/dist/system.src.js'
];

gulp.task('angular', function () {
    return gulp.src(angular).pipe(gulp.dest(paths.angular));
});

gulp.task('angular2InMemoryWebApi', function () {
    return gulp.src(angular2InMemoryWebApi).pipe(gulp.dest(paths.angular2InMemoryWebApi));
});

gulp.task('rxjs', function () {
    return gulp.src(rxjs).pipe(gulp.dest(paths.rxjs));
});

gulp.task('libs', function () {
    return gulp.src(libs).pipe(gulp.dest(paths.lib));
});

gulp.task('clean', function (callback) {
    rimraf(paths.lib, callback);
});