﻿using System;
using System.Web.Http.Filters;
using System.Web.Http.Controllers;
using System.Net;
using System.Net.Http;

namespace RequireHttps
{
    public class RequireHttpsAttribute : AuthorizationFilterAttribute
    {
        public override void OnAuthorization(HttpActionContext actionContext)
        {
            if (actionContext.Request.RequestUri.Scheme != Uri.UriSchemeHttps)
                actionContext.Response = new HttpResponseMessage(HttpStatusCode.Forbidden) { ReasonPhrase = "HTTPS Required" };
            else
                base.OnAuthorization(actionContext);
        }
    }
}
