﻿using System;
using System.Threading;
using System.Threading.Tasks;
using System.Text;
using System.Net;

namespace HttpClient
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.Write("Devices Simulator\nPress any key to start...\n");
            Console.ReadKey();

            // To ignore SSL certificate check
            ServicePointManager.ServerCertificateValidationCallback = (sender, cert, chain, sslPolicyErrors) => true;

            HttpHelper httpHelper = new HttpHelper { User = "...", Password = "..." };

            httpHelper.RegisterDevice(/* deviceId */           115,
                                      /* deviceType */         "TypeX", 
                                      /* deviceName */         "T1", 
                                      /* description */        "Temperature in Area 1", 
                                      /* deviceSpecificData */ "ABC");
            httpHelper.RegisterDevice(215, "TypeX", "H", "Humidity measurement", "ABC");
            httpHelper.RegisterDevice(315, "TypeX", "P1", "Pressure in Area 1", "ABC");
            httpHelper.RegisterDevice(120, "TypeX", "T2", "Temperature in Area 2", "ABC");
            httpHelper.RegisterDevice(320, "TypeX", "P2", "Pressure in Area 2", "ABC");

            int interval = 5000;

            while (true)
            {
                httpHelper.DeviceData(115, -10);
                httpHelper.DeviceData(215, -10);
                httpHelper.DeviceData(315, -10);
                httpHelper.DeviceData(120, -10);
                httpHelper.DeviceData(320,  50);
                Thread.Sleep(interval);

                httpHelper.DeviceData(115, 10);
                httpHelper.DeviceData(215, 10);
                httpHelper.DeviceData(315, 10);
                httpHelper.DeviceData(120, 10);
                Thread.Sleep(interval);

                httpHelper.DeviceData(115, 50);
                httpHelper.DeviceData(215, 50);
                httpHelper.DeviceData(315, 50);
                httpHelper.DeviceData(120, 50);
                Thread.Sleep(interval);

                httpHelper.DeviceData(115, 80);
                httpHelper.DeviceData(215, 80);
                httpHelper.DeviceData(315, 80);
                httpHelper.DeviceData(120, 80);
                Thread.Sleep(interval);

                httpHelper.DeviceData(115, 110);
                httpHelper.DeviceData(215, 110);
                httpHelper.DeviceData(315, 110);
                httpHelper.DeviceData(120, 110);
                Thread.Sleep(interval);
            }
        }
    }

    public static class HttpHelperEx 
    {
        private static string UriHeader 
        {
            get { return "https://localhost:44301"; }
        }

        public static void RegisterDevice(this HttpHelper httpHelper, params object[] items)
        {
            Get(httpHelper, UriHeader + string.Format("/api/RegisterDevice/{0}/{1}/{2}/{3}/{4}", items));
        }

        public static void DeviceData(this HttpHelper httpHelper, params object[] items)
        {
            Get(httpHelper, UriHeader + string.Format("/api/DeviceData/{0}/{1}", items));
        }

        public static void Get(this HttpHelper httpHelper, string url) 
        {
            const int iTimeoutInSec = 60;
            var btOut = httpHelper.Get(url, iTimeoutInSec);
            var sr = Encoding.UTF8.GetString(btOut, 0, btOut.Length);
            Console.WriteLine(sr);
        }
    }
}
