using System;
using System.IO;
using System.Net;

namespace HttpClient
{
	public class HttpHelper
	{	
        public string User { get; set; }
        public string Password { get; set; }

        public byte[] Get(string strUrl, int timeoutInSec)
        {
            // Create Web Request 
            var request = WebRequest.Create(strUrl) as HttpWebRequest;

            // Set Credentials
            request.Credentials = new NetworkCredential(User, Password);

            // Set Timeout
            request.Timeout = 1000 * timeoutInSec;

            // Response
            var response = request.GetResponse() as HttpWebResponse;
            byte[] btOut = GetBytesResponse(response);

            response.Close();

            return btOut;
        }

        public byte[] GetBytesResponse(HttpWebResponse response)
		{
			Stream smResponse = response.GetResponseStream();

			int chunkLen = 512;
			byte[] btResponse = new byte[chunkLen];
			MemoryStream outStream = new MemoryStream();
			int read = 0;
			while (true)
			{
				read = smResponse.Read(btResponse, 0, chunkLen);
				if (read > 0)
					outStream.Write(btResponse, 0, read);
				else
					break;
			}

			response.Close();

			return outStream.ToArray();		
		}
	}
}
 

