﻿using System;
using System.Web;
using System.Web.Http;
using System.Net;
using DeviceXApp.Controllers;
using KeepAlive;

namespace DeviceXApp
{
    public class WebApiApplication : HttpApplication
    {
        protected void Application_Start()
        {
            DeviceController.Configure();

            GlobalConfiguration.Configure(WebApiConfig.Register);

            // To ignore SSL certificate check
            ServicePointManager.ServerCertificateValidationCallback = (sender, cert, chain, sslPolicyErrors) => true;
        }

        protected void Application_BeginRequest(object source, EventArgs e)
        {
            KeepAliveController.InitKeepAlive(source as HttpApplication);
        }
    }
}
