﻿using System.Collections.Generic;
using System.Linq;
using System.Web.Script.Serialization;

namespace DeviceModel
{
    public enum DeviceStatus
    {
        NoData,
        Ok,
        Warning,
        Error,
    }

    public class Device
    {
        public int Id { get; set; }
        public DeviceStatus Status { get; set; }
        public string StatusAsString
        {
            get { return Status.ToString(); }
        }
    }

    public class DeviceInfo 
    {
        public int CategoryId { get; set; }
        public int Id { get; set; }
        public string DeviceType { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public string DeviceSpecificData { get; set; }

        public bool IsNew(IEnumerable<DeviceInfo> devices)
        {
            if (devices == null)
                return false;

            if (devices.Count() == 0)
                return true;

            return devices.Where(d => d.Id == Id).FirstOrDefault() == null;
        }

        public static DeviceInfo FromJson(string json) 
        {
            return new JavaScriptSerializer().Deserialize<DeviceInfo>(json);
        }
    }

    public class CategoryInfo
    {
        public int Id { get; set; }
        public string Name { get; set; }
        public string Description { get; set; }
        public int LowestDeviceId { get; set; }
        public  int HighestDeviceId { get; set; }

        public bool IsNew(IEnumerable<CategoryInfo> categories)
        {
            if (categories == null)
                return false;

            if (categories.Count() == 0)
                return true;

            return categories.Where(c => c.Id == Id).FirstOrDefault() == null;
        }

        public bool DoesBelongTo(int deviceId)
        {
            return deviceId > LowestDeviceId && deviceId <= HighestDeviceId;
        }
    }
}
