import {bootstrap} from 'angular2/platform/browser';
import {Component} from 'angular2/core';
import {NgFor} from 'angular2/common';
import {CommunicationService} from 'app/services/communication.ts';

@Component({
	selector: 'main1',
	providers: [CommunicationService],
	templateUrl: 'app/components/application/application.html',
	styleUrls: ['app/components/application/application.css', 'Styles/styles.css'],
	directives: [NgFor]
})
export default class ApplicationComponent {
	
	public currentServerTime: string;
	
	private comm: CommunicationService;
	
	public imagesUrl: Array<string> = ['expand.png', 'collapse.png'];
    public imageIndex: Array<int> = [];
    public image: Array<string> = [];
    public categoryIndicator: Array<int> = [];
    public categoryIndicatorAsString: Array<string> = [];
	public allCategoriesInfo: Array<any> = [];
	public allDevicesInfo: Array<any> = [];
	public allDevices: Array<any> = [];
	
	constructor(private comm: CommunicationService) {
			
		if (comm) {		
			this.comm = comm;

            comm.getServerTime(data => this.currentServerTime = data);	
			
			comm.subscribeToBrowserFunction('devicesHub', 'all', lst => {
				
				this.allCategoriesInfo = lst[0];

				if (this.allCategoriesInfo != null)
					for (var i = 0; i < this.allCategoriesInfo.length; i++) {
						this.imageIndex.push(0);
						this.image.push(this.imagesUrl[0]);
						this.categoryIndicator.push(0);
						this.categoryIndicatorAsString.push('NoData');
					}
					
				this.allDevicesInfo = lst[1];	
							
				this.allDevicesFunc(lst[2]);
			});
			
			comm.subscribeToBrowserFunction('devicesHub', 'allDevices', devices => {
				this.allDevicesFunc(devices);
			});
			
			comm.subscribeToBrowserFunction('devicesHub', 'serverTime', timeAsString => {
				this.currentServerTime = timeAsString;
			});
			
			comm.init();
		}
	}
	
	allDevicesFunc(devices: Array<any>) {
		
		this.allDevices = devices;
			
		if (this.allDevicesInfo != null && this.allDevices != null && this.allCategoriesInfo != null && 
		    this.allDevicesInfo.length == this.allDevices.length && this.allDevices.length > 0) {
			
			// Overall category indicator
			for (var i = 0; i < this.allCategoriesInfo.length; i++) {
				this.categoryIndicator[i] = 0;

				for (var j = 0; j < this.allDevices.length; j++) {

					if (this.allCategoriesInfo[i].Id == this.allDevicesInfo[j].CategoryId &&
						this.allDevices[j].Status >= this.categoryIndicator[i]) {
						
						this.categoryIndicator[i] = this.allDevices[j].Status;
						this.categoryIndicatorAsString[i] = this.allDevices[j].StatusAsString;
					}
				}
			}
		}
	}
			
	toggleImage(categoryIndex: int) {
		this.imageIndex[categoryIndex] = (this.imageIndex[categoryIndex] + 1) % 2;
		this.image[categoryIndex] = this.imagesUrl[this.imageIndex[categoryIndex]];
	}
	
	getServerTime() {
		this.comm.getServerTime(data => this.currentServerTime = data);
	}
}
